/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectProducer
extends DefaultProducer
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(DirectProducer.class);
    private DirectEndpoint endpoint;

    public DirectProducer(DirectEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.endpoint.getConsumers().isEmpty()) {
            LOG.warn((Object)("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange));
        } else {
            for (DefaultConsumer consumer : this.endpoint.getConsumers()) {
                consumer.getProcessor().process(exchange);
            }
        }
    }
}

