/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchangeHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(DefaultExchangeHolder.class);
    private Object inBody;
    private Object outBody;
    private Boolean outFaultFlag = Boolean.FALSE;
    private final Map<String, Object> inHeaders = new LinkedHashMap<String, Object>();
    private final Map<String, Object> outHeaders = new LinkedHashMap<String, Object>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Exception exception;

    public static DefaultExchangeHolder marshal(Exchange exchange) {
        DefaultExchangeHolder payload = new DefaultExchangeHolder();
        payload.inBody = DefaultExchangeHolder.checkSerializableObject("in body", exchange, exchange.getIn().getBody());
        payload.inHeaders.putAll(DefaultExchangeHolder.checkMapSerializableObjects("in headers", exchange, exchange.getIn().getHeaders()));
        if (exchange.hasOut()) {
            payload.outBody = DefaultExchangeHolder.checkSerializableObject("out body", exchange, exchange.getOut().getBody());
            payload.outHeaders.putAll(DefaultExchangeHolder.checkMapSerializableObjects("out headers", exchange, exchange.getOut().getHeaders()));
            payload.outFaultFlag = exchange.getOut().isFault();
        }
        payload.properties.putAll(DefaultExchangeHolder.checkMapSerializableObjects("exchange properties", exchange, exchange.getProperties()));
        payload.exception = exchange.getException();
        return payload;
    }

    public static void unmarshal(Exchange exchange, DefaultExchangeHolder payload) {
        exchange.getIn().setBody(payload.inBody);
        exchange.getIn().setHeaders(payload.inHeaders);
        if (payload.outBody != null) {
            exchange.getOut().setBody(payload.outBody);
            exchange.getOut().setHeaders(payload.outHeaders);
            exchange.getOut().setFault(payload.outFaultFlag);
        }
        for (String key : payload.properties.keySet()) {
            exchange.setProperty(key, payload.properties.get(key));
        }
        exchange.setException(payload.exception);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultExchangeHolder[");
        sb.append("inBody=").append(this.inBody).append(", outBody=").append(this.outBody);
        sb.append(", inHeaders=").append(this.inHeaders).append(", outHeaders=").append(this.outHeaders);
        sb.append(", properties=").append(this.properties).append(", exception=").append(this.exception);
        return sb.append(']').toString();
    }

    private static Object checkSerializableObject(String type, Exchange exchange, Object object) {
        if (object == null) {
            return null;
        }
        Serializable converted = exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, object);
        if (converted != null) {
            return converted;
        }
        LOG.warn((Object)(type + " containing object: " + object + " of type: " + object.getClass().getCanonicalName() + " cannot be serialized, it will be excluded by the holder."));
        return null;
    }

    private static Map<String, Object> checkMapSerializableObjects(String type, Exchange exchange, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Serializable converted = exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, entry.getValue());
            if (converted != null) {
                result.put(entry.getKey(), converted);
                continue;
            }
            LOG.warn((Object)(type + " containing object: " + entry.getValue() + " with key: " + entry.getKey() + " cannot be serialized, it will be excluded by the holder."));
        }
        return result;
    }
}

