/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.ObjectHelper;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Route")
public class ManagedRoute
extends ManagedPerformanceCounter {
    public static final String VALUE_UNKNOWN = "Unknown";
    private Route route;
    private String description;
    private CamelContext context;

    public ManagedRoute(CamelContext context, Route route) {
        this.route = route;
        this.context = context;
        this.description = route.toString();
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public Route getRoute() {
        return this.route;
    }

    public CamelContext getContext() {
        return this.context;
    }

    @ManagedAttribute(description="Route id")
    public String getRouteId() {
        String id = this.route.getId();
        if (id == null) {
            id = VALUE_UNKNOWN;
        }
        return id;
    }

    @ManagedAttribute(description="Route Description")
    public String getDescription() {
        return this.description;
    }

    @ManagedAttribute(description="Route Endpoint Uri")
    public String getEndpointUri() {
        Endpoint ep = this.route.getEndpoint();
        return ep != null ? ep.getEndpointUri() : VALUE_UNKNOWN;
    }

    @ManagedAttribute(description="Route State")
    public String getState() {
        ServiceStatus status = this.context.getRouteStatus(this.route.getId());
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute(description="Current number of inflight Exchanges")
    public Integer getInflightExchanges() {
        if (this.route.getEndpoint() != null) {
            return this.context.getInflightRepository().size(this.route.getEndpoint());
        }
        return null;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.context.getName();
    }

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing() {
        return this.route.getRouteContext().isTracing();
    }

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean tracing) {
        this.route.getRouteContext().setTracing(tracing);
    }

    @ManagedAttribute(description="Route Policy")
    public String getRoutePolicy() {
        RoutePolicy policy = this.route.getRouteContext().getRoutePolicy();
        if (policy != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(policy.getClass().getSimpleName());
            sb.append("(").append(ObjectHelper.getIdentityHashCode(policy)).append(")");
            return sb.toString();
        }
        return null;
    }

    @ManagedOperation(description="Start Route")
    public void start() throws Exception {
        this.context.startRoute(this.getRouteId());
    }

    @ManagedOperation(description="Stop Route")
    public void stop() throws Exception {
        this.context.stopRoute(this.getRouteId());
    }
}

