/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.StreamCache;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.MessageHelper;

public class StreamCachingInterceptor
extends DelegateProcessor {
    public StreamCachingInterceptor() {
    }

    public StreamCachingInterceptor(Processor processor) {
        this();
        this.setProcessor(processor);
    }

    public String toString() {
        return "StreamCachingInterceptor[" + this.processor + "]";
    }

    public void process(Exchange exchange) throws Exception {
        StreamCache newBody = exchange.getIn().getBody(StreamCache.class);
        if (newBody != null) {
            exchange.getIn().setBody(newBody);
        }
        MessageHelper.resetStreamCache(exchange.getIn());
        this.getProcessor().process(exchange);
    }
}

