/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultShutdownStrategy
extends ServiceSupport
implements ShutdownStrategy,
CamelContextAware {
    private static final transient Log LOG = LogFactory.getLog(DefaultShutdownStrategy.class);
    private CamelContext camelContext;
    private ExecutorService executor;
    private long timeout = 300L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean shutdownNowOnTimeout = true;
    private boolean shutdownRoutesInReverseOrder = true;

    public DefaultShutdownStrategy() {
    }

    public DefaultShutdownStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void shutdown(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.shutdown(context, routes, this.getTimeout(), this.getTimeUnit());
    }

    @Override
    public void suspend(CamelContext context, List<RouteStartupOrder> routes) throws Exception {
        this.doShutdown(context, routes, this.getTimeout(), this.getTimeUnit(), true);
    }

    @Override
    public void shutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, false);
    }

    @Override
    public void suspend(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdown(context, routes, timeout, timeUnit, true);
    }

    protected void doShutdown(CamelContext context, List<RouteStartupOrder> routes, long timeout, TimeUnit timeUnit, boolean suspendOnly) throws Exception {
        StopWatch watch = new StopWatch();
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(routes);
        Collections.sort(routesOrdered, new Comparator<RouteStartupOrder>(){

            @Override
            public int compare(RouteStartupOrder o1, RouteStartupOrder o2) {
                return o1.getStartupOrder() - o2.getStartupOrder();
            }
        });
        if (this.shutdownRoutesInReverseOrder) {
            Collections.reverse(routesOrdered);
        }
        if (timeout > 0L) {
            LOG.info((Object)("Starting to graceful shutdown " + routesOrdered.size() + " routes (timeout " + timeout + " " + timeUnit.toString().toLowerCase() + ")"));
        } else {
            LOG.info((Object)("Starting to graceful shutdown " + routesOrdered.size() + " routes (no timeout)"));
        }
        Future<?> future = this.getExecutorService().submit(new ShutdownTask(context, routesOrdered, suspendOnly));
        try {
            if (timeout > 0L) {
                future.get(timeout, timeUnit);
            } else {
                future.get();
            }
        }
        catch (TimeoutException e) {
            future.cancel(true);
            if (this.shutdownNowOnTimeout) {
                LOG.warn((Object)"Timeout occurred. Now forcing the routes to be shutdown now.");
                this.shutdownRoutesNow(routesOrdered);
            } else {
                LOG.warn((Object)"Timeout occurred. Will ignore shutting down the remainder routes.");
            }
        }
        catch (ExecutionException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e.getCause());
        }
        long seconds = TimeUnit.SECONDS.convert(watch.stop(), TimeUnit.MILLISECONDS);
        LOG.info((Object)("Graceful shutdown of " + routesOrdered.size() + " routes completed in " + seconds + " seconds"));
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.shutdownNowOnTimeout = shutdownNowOnTimeout;
    }

    @Override
    public boolean isShutdownNowOnTimeout() {
        return this.shutdownNowOnTimeout;
    }

    @Override
    public boolean isShutdownRoutesInReverseOrder() {
        return this.shutdownRoutesInReverseOrder;
    }

    @Override
    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.shutdownRoutesInReverseOrder = shutdownRoutesInReverseOrder;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void shutdownRoutesNow(List<RouteStartupOrder> routes) {
        for (RouteStartupOrder order : routes) {
            ShutdownRunningTask current = order.getRoute().getRouteContext().getShutdownRunningTask();
            if (current != ShutdownRunningTask.CompleteCurrentTaskOnly) {
                LOG.info((Object)("Changing shutdownRunningTask from " + (Object)((Object)current) + " to " + (Object)((Object)ShutdownRunningTask.CompleteCurrentTaskOnly) + " on route " + order.getRoute().getId() + " to shutdown faster"));
                order.getRoute().getRouteContext().setShutdownRunningTask(ShutdownRunningTask.CompleteCurrentTaskOnly);
            }
            for (Consumer consumer : order.getInputs()) {
                this.shutdownNow(consumer);
            }
        }
    }

    protected void shutdownNow(List<Consumer> consumers) {
        for (Consumer consumer : consumers) {
            this.shutdownNow(consumer);
        }
    }

    protected void shutdownNow(Consumer consumer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Shutting down: " + consumer));
        }
        try {
            ServiceHelper.stopService(consumer);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error occurred while shutting down route: " + consumer + ". This exception will be ignored."), e);
            EventHelper.notifyServiceStopFailure(consumer.getEndpoint().getCamelContext(), consumer, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Shutdown complete for: " + consumer));
        }
    }

    protected void suspendNow(Consumer consumer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Suspending: " + consumer));
        }
        try {
            ServiceHelper.suspendService(consumer);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error occurred while suspending route: " + consumer + ". This exception will be ignored."), e);
            EventHelper.notifyServiceStopFailure(consumer.getEndpoint().getCamelContext(), consumer, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suspend complete for: " + consumer));
        }
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = this.camelContext.getExecutorServiceStrategy().newSingleThreadExecutor(this, "ShutdownTask");
        }
        return this.executor;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.executor != null) {
            this.camelContext.getExecutorServiceStrategy().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShutdownTask
    implements Runnable {
        private final CamelContext context;
        private final List<RouteStartupOrder> routes;
        private final boolean suspendOnly;

        public ShutdownTask(CamelContext context, List<RouteStartupOrder> routes, boolean suspendOnly) {
            this.context = context;
            this.routes = routes;
            this.suspendOnly = suspendOnly;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There are " + this.routes.size() + " routes to " + (this.suspendOnly ? "suspend" : "shutdown")));
            }
            ArrayList<ShutdownDeferredConsumer> deferredConsumers = new ArrayList<ShutdownDeferredConsumer>();
            for (RouteStartupOrder order : this.routes) {
                ShutdownRoute shutdownRoute = order.getRoute().getRouteContext().getShutdownRoute();
                ShutdownRunningTask shutdownRunningTask = order.getRoute().getRouteContext().getShutdownRunningTask();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)((this.suspendOnly ? "Suspending route: " : "Shutting down route: ") + order.getRoute().getId() + " with options [" + (Object)((Object)shutdownRoute) + "," + (Object)((Object)shutdownRunningTask) + "]"));
                }
                for (Consumer consumer : order.getInputs()) {
                    boolean shutdown;
                    boolean suspend = false;
                    boolean bl = shutdown = shutdownRoute != ShutdownRoute.Defer;
                    if (shutdown) {
                        if (consumer instanceof ShutdownAware) {
                            boolean bl2 = shutdown = !((ShutdownAware)((Object)consumer)).deferShutdown(shutdownRunningTask);
                        }
                        if (shutdown && consumer instanceof SuspendableService) {
                            suspend = true;
                        }
                    }
                    if (suspend) {
                        DefaultShutdownStrategy.this.suspendNow(consumer);
                        deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer));
                        LOG.info((Object)("Route: " + order.getRoute().getId() + " suspended and shutdown deferred, was consuming from: " + order.getRoute().getEndpoint()));
                        continue;
                    }
                    if (shutdown) {
                        DefaultShutdownStrategy.this.shutdownNow(consumer);
                        LOG.info((Object)("Route: " + order.getRoute().getId() + " shutdown complete, was consuming from: " + order.getRoute().getEndpoint()));
                        continue;
                    }
                    deferredConsumers.add(new ShutdownDeferredConsumer(order.getRoute(), consumer));
                    LOG.info((Object)("Route: " + order.getRoute().getId() + (this.suspendOnly ? " shutdown deferred." : " suspension deferred.")));
                }
            }
            boolean done = false;
            long loopDelaySeconds = 1L;
            long loopCount = 0L;
            while (!done) {
                int size = 0;
                for (RouteStartupOrder order : this.routes) {
                    for (Consumer consumer : order.getInputs()) {
                        int inflight = this.context.getInflightRepository().size(consumer.getEndpoint());
                        if (consumer instanceof ShutdownAware) {
                            inflight += ((ShutdownAware)((Object)consumer)).getPendingExchangesSize();
                        }
                        if (inflight <= 0) continue;
                        size += inflight;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)(inflight + " inflight and pending exchanges for consumer: " + consumer));
                    }
                }
                if (size > 0) {
                    try {
                        LOG.info((Object)("Waiting as there are still " + size + " inflight and pending exchanges to complete, timeout in " + (TimeUnit.SECONDS.convert(DefaultShutdownStrategy.this.getTimeout(), DefaultShutdownStrategy.this.getTimeUnit()) - loopCount++ * loopDelaySeconds) + " seconds."));
                        Thread.sleep(loopDelaySeconds * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Interrupted while waiting during graceful shutdown, will force shutdown now.");
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                done = true;
            }
            for (ShutdownDeferredConsumer deferred : deferredConsumers) {
                if (this.suspendOnly) {
                    DefaultShutdownStrategy.this.suspendNow(deferred.getConsumer());
                    LOG.info((Object)("Route: " + deferred.getRoute().getId() + " suspend complete."));
                    continue;
                }
                DefaultShutdownStrategy.this.shutdownNow(deferred.getConsumer());
                LOG.info((Object)("Route: " + deferred.getRoute().getId() + " shutdown complete."));
            }
        }
    }

    class ShutdownDeferredConsumer {
        private final Route route;
        private final Consumer consumer;

        ShutdownDeferredConsumer(Route route, Consumer consumer) {
            this.route = route;
            this.consumer = consumer;
        }

        Route getRoute() {
            return this.route;
        }

        Consumer getConsumer() {
            return this.consumer;
        }
    }
}

