/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ProfileRequirements
implements Comparable<ProfileRequirements> {
    private String profile;
    private Integer minimumInstances;
    private Integer maximumInstances;
    private List<String> dependentProfiles;

    public ProfileRequirements() {
    }

    public ProfileRequirements(String profile) {
        this.profile = profile;
    }

    public ProfileRequirements(String profile, Integer minimumInstances) {
        this(profile);
        this.minimumInstances = minimumInstances;
    }

    public ProfileRequirements(String profile, Integer minimumInstances, Integer maximumInstances) {
        this(profile, minimumInstances);
        this.maximumInstances = maximumInstances;
    }

    public ProfileRequirements(String profile, Integer minimumInstances, Integer maximumInstances, List<String> dependentProfiles) {
        this(profile, minimumInstances, maximumInstances);
        this.dependentProfiles = dependentProfiles;
    }

    public ProfileRequirements(String profile, Integer minimumInstances, Integer maximumInstances, String ... dependentProfiles) {
        this(profile, minimumInstances, maximumInstances);
        this.dependentProfiles = new ArrayList<String>(Arrays.asList(dependentProfiles));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileRequirements that = (ProfileRequirements)o;
        return this.profile.equals(that.profile);
    }

    @Override
    public int compareTo(ProfileRequirements o) {
        return this.profile.compareTo(o.profile);
    }

    public int hashCode() {
        return this.profile.hashCode();
    }

    public String toString() {
        return "ProfileRequirements[" + this.profile + " " + ProfileRequirements.getOrBlank(this.minimumInstances) + ".." + ProfileRequirements.getOrBlank(this.maximumInstances) + "]";
    }

    private static String getOrBlank(Object value) {
        return value != null ? value.toString() : "";
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public List<String> getDependentProfiles() {
        return this.dependentProfiles;
    }

    public void setDependentProfiles(List<String> dependentProfiles) {
        this.dependentProfiles = dependentProfiles;
    }

    public Integer getMaximumInstances() {
        return this.maximumInstances;
    }

    public void setMaximumInstances(Integer maximumInstances) {
        this.maximumInstances = maximumInstances;
    }

    public Integer getMinimumInstances() {
        return this.minimumInstances;
    }

    public void setMinimumInstances(Integer minimumInstances) {
        this.minimumInstances = minimumInstances;
    }

    public double getHealth(int instances) {
        if (instances <= 0) {
            return 0.0;
        }
        if (this.minimumInstances != null) {
            int min = this.minimumInstances;
            if (min <= 0) {
                return 1.0;
            }
            return 1.0 * (double)instances / (double)min;
        }
        return 1.0;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return ProfileRequirements.isEmpty(this.minimumInstances) && ProfileRequirements.isEmpty(this.maximumInstances) && ProfileRequirements.isEmpty(this.dependentProfiles);
    }

    protected static boolean isEmpty(Integer number) {
        return number == null || number == 0;
    }

    protected static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }
}

