/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api.jmx;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.HasId;
import org.fusesource.fabric.api.Ids;
import org.fusesource.fabric.api.Versions;

public class ContainerDTO
implements HasId {
    private String id;
    private boolean alive;
    private boolean managed;
    private boolean ensembleServer;
    private boolean provisioningComplete;
    private boolean root;
    private boolean provisioningPending;
    private String ip;
    private List<String> jmxDomains;
    private List<String> childrenIds;
    private String jmxUrl;
    private String localHostName;
    private String localIp;
    private String location;
    private String manualIp;
    private int maximumPort;
    private int minimumPort;
    private String parentId;
    private List<String> profileIds;
    private String provisionException;
    private String provisionResult;
    private String provisionStatus;
    private String publicHostname;
    private String publicIp;
    private String resolver;
    private String sshUrl;
    private String type;
    private String versionId;
    private String geoLocation;

    public static ContainerDTO newInstance(Container container) {
        if (container != null) {
            return new ContainerDTO(container);
        }
        return null;
    }

    public static List<ContainerDTO> newInstances(Container ... containers) {
        ArrayList<ContainerDTO> answer = new ArrayList<ContainerDTO>();
        if (containers != null) {
            for (Container container : containers) {
                ContainerDTO dto = ContainerDTO.newInstance(container);
                if (dto == null) continue;
                answer.add(dto);
            }
        }
        return answer;
    }

    public ContainerDTO() {
    }

    public ContainerDTO(Container container) {
        this.id = container.getId();
        this.ip = container.getIp();
        this.alive = container.isAlive();
        this.managed = container.isManaged();
        this.ensembleServer = container.isEnsembleServer();
        this.root = container.isRoot();
        this.provisioningComplete = container.isProvisioningComplete();
        this.provisioningPending = container.isProvisioningPending();
        this.jmxDomains = container.getJmxDomains();
        this.childrenIds = Ids.getIds(container.getChildren());
        this.jmxUrl = container.getJmxUrl();
        this.localHostName = container.getLocalHostname();
        this.localIp = container.getLocalIp();
        this.location = container.getLocation();
        this.manualIp = container.getManulIp();
        this.maximumPort = container.getMaximumPort();
        this.minimumPort = container.getMinimumPort();
        this.parentId = Ids.getId(container.getParent());
        this.profileIds = Ids.getIds(container.getProfiles());
        this.provisionException = container.getProvisionException();
        this.provisionResult = container.getProvisionResult();
        this.provisionStatus = container.getProvisionStatus();
        this.publicHostname = container.getPublicHostname();
        this.publicIp = container.getPublicIp();
        this.resolver = container.getResolver();
        this.sshUrl = container.getSshUrl();
        this.type = container.getType();
        this.versionId = Versions.getId(container.getVersion());
        this.geoLocation = container.getGeoLocation();
    }

    public String toString() {
        return "ContainerDTO(" + this.id + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerDTO that = (ContainerDTO)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public List<String> getChildrenIds() {
        return this.childrenIds;
    }

    public void setChildrenIds(List<String> childrenIds) {
        this.childrenIds = childrenIds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public List<String> getJmxDomains() {
        return this.jmxDomains;
    }

    public void setJmxDomains(List<String> jmxDomains) {
        this.jmxDomains = jmxDomains;
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public void setJmxUrl(String jmxUrl) {
        this.jmxUrl = jmxUrl;
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    public void setLocalHostName(String localHostName) {
        this.localHostName = localHostName;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getManualIp() {
        return this.manualIp;
    }

    public void setManualIp(String manualIp) {
        this.manualIp = manualIp;
    }

    public int getMaximumPort() {
        return this.maximumPort;
    }

    public void setMaximumPort(int maximumPort) {
        this.maximumPort = maximumPort;
    }

    public int getMinimumPort() {
        return this.minimumPort;
    }

    public void setMinimumPort(int minimumPort) {
        this.minimumPort = minimumPort;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<String> getProfileIds() {
        return this.profileIds;
    }

    public void setProfileIds(List<String> profileIds) {
        this.profileIds = profileIds;
    }

    public String getProvisionException() {
        return this.provisionException;
    }

    public void setProvisionException(String provisionException) {
        this.provisionException = provisionException;
    }

    public String getProvisionResult() {
        return this.provisionResult;
    }

    public void setProvisionResult(String provisionResult) {
        this.provisionResult = provisionResult;
    }

    public String getProvisionStatus() {
        return this.provisionStatus;
    }

    public void setProvisionStatus(String provisionStatus) {
        this.provisionStatus = provisionStatus;
    }

    public String getPublicHostname() {
        return this.publicHostname;
    }

    public void setPublicHostname(String publicHostname) {
        this.publicHostname = publicHostname;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public void setSshUrl(String sshUrl) {
        this.sshUrl = sshUrl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public boolean isEnsembleServer() {
        return this.ensembleServer;
    }

    public void setEnsembleServer(boolean ensembleServer) {
        this.ensembleServer = ensembleServer;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public boolean isProvisioningComplete() {
        return this.provisioningComplete;
    }

    public void setProvisioningComplete(boolean provisioningComplete) {
        this.provisioningComplete = provisioningComplete;
    }

    public boolean isProvisioningPending() {
        return this.provisioningPending;
    }

    public void setProvisioningPending(boolean provisioningPending) {
        this.provisioningPending = provisioningPending;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public String getGeoLocation() {
        return this.geoLocation;
    }

    public void setGeoLocation(String geoLocation) {
        this.geoLocation = geoLocation;
    }
}

