/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.HasId;
import org.fusesource.fabric.api.Ids;
import org.fusesource.fabric.api.Profile;

public class ProfileDTO
implements HasId {
    private String id;
    private Properties attributes;
    private List<String> bundles;
    private List<String> fabs;
    private List<String> features;
    private List<String> overrides;
    private List<String> repositories;
    private List<String> parentIds;
    private List<String> childIds;
    private List<String> containers;
    private List<String> configurations;
    private int containerCount;
    private boolean abstractProfile;
    private boolean hidden;
    private boolean locked;
    private boolean overlay;

    public static ProfileDTO newInstance(FabricService service, Profile profile) {
        if (profile != null) {
            return new ProfileDTO(service, profile);
        }
        return null;
    }

    public static List<ProfileDTO> newInstances(FabricService service, Profile ... profiles) {
        ArrayList<ProfileDTO> answer = new ArrayList<ProfileDTO>();
        if (profiles != null) {
            for (Profile profile : profiles) {
                ProfileDTO dto = ProfileDTO.newInstance(service, profile);
                if (dto == null) continue;
                answer.add(dto);
            }
        }
        return answer;
    }

    public ProfileDTO() {
    }

    public ProfileDTO(FabricService service, Profile profile) {
        this.id = profile.getId();
        this.attributes = profile.getAttributes();
        this.bundles = profile.getBundles();
        this.fabs = profile.getFabs();
        this.features = profile.getFeatures();
        this.overrides = profile.getOverrides();
        this.repositories = profile.getRepositories();
        this.parentIds = Ids.getIds(profile.getParents());
        this.abstractProfile = profile.isAbstract();
        this.hidden = profile.isHidden();
        this.locked = profile.isLocked();
        this.overlay = profile.isOverlay();
        this.configurations = new ArrayList<String>();
        this.configurations.addAll(profile.getFileConfigurations().keySet());
        this.childIds = new ArrayList<String>();
        block0: for (Profile profile2 : service.getVersion(profile.getVersion()).getProfiles()) {
            for (Profile parent : profile2.getParents()) {
                if (!parent.getId().equals(this.getId())) continue;
                this.childIds.add(profile2.getId());
                continue block0;
            }
        }
        this.containers = new ArrayList<String>();
        this.containerCount = 0;
        for (HasId hasId : profile.getAssociatedContainers()) {
            ++this.containerCount;
            this.containers.add(hasId.getId());
        }
    }

    public String toString() {
        return "ProfileDTO(" + this.id + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileDTO that = (ProfileDTO)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    public List<String> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<String> bundles) {
        this.bundles = bundles;
    }

    public List<String> getFabs() {
        return this.fabs;
    }

    public void setFabs(List<String> fabs) {
        this.fabs = fabs;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(List<String> overrides) {
        this.overrides = overrides;
    }

    public List<String> getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(List<String> parentIds) {
        this.parentIds = parentIds;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public int getContainerCount() {
        return this.containerCount;
    }

    public void setContainerCount(int containerCount) {
        this.containerCount = containerCount;
    }

    public boolean isAbstractProfile() {
        return this.abstractProfile;
    }

    public void setAbstractProfile(boolean abstractProfile) {
        this.abstractProfile = abstractProfile;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<String> configurations) {
        this.configurations = configurations;
    }

    public List<String> getChildIds() {
        return this.childIds;
    }

    public void setChildIds(List<String> childIds) {
        this.childIds = childIds;
    }

    public List<String> getContainers() {
        return this.containers;
    }

    public void setContainers(List<String> containers) {
        this.containers = containers;
    }
}

