/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.FabricRequirements;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.FabricStatus;
import org.fusesource.fabric.api.PatchService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.jmx.FabricManager;
import org.fusesource.fabric.api.jmx.HealthCheck;
import org.fusesource.fabric.internal.ContainerImpl;
import org.fusesource.fabric.internal.ProfileImpl;
import org.fusesource.fabric.internal.RequirementsJson;
import org.fusesource.fabric.internal.VersionImpl;
import org.fusesource.fabric.service.ChildContainerProvider;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.PatchServiceImpl;
import org.fusesource.fabric.utils.Base64Encoder;
import org.fusesource.fabric.utils.ObjectUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.ZkProfiles;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricServiceImpl
implements FabricService {
    public static final String REQUIREMENTS_JSON_PATH = "/fabric/configs/org.fusesource.fabric.requirements.json";
    public static final String JVM_OPTIONS_PATH = "/fabric/configs/org.fusesource.fabric.containers.jvmOptions";
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricServiceImpl.class);
    private IZKClient zooKeeper;
    private Map<String, ContainerProvider> providers;
    private ConfigurationAdmin configurationAdmin;
    private String profile = "default";
    private String defaultRepo = "http://repo.fusesource.com/nexus/content/groups/public/";
    private MBeanServer mbeanServer;
    private HealthCheck healthCheck = new HealthCheck(this);
    private FabricManager managerMBean = new FabricManager(this);

    public FabricServiceImpl() {
        this.providers = new ConcurrentHashMap<String, ContainerProvider>();
        this.providers.put("child", new ChildContainerProvider(this));
    }

    public void init() {
        MBeanServer server = this.getMbeanServer();
        if (server != null) {
            this.healthCheck.registerMBeanServer(server);
            this.managerMBean.registerMBeanServer(server);
        }
    }

    public void destroy() {
        if (this.mbeanServer != null) {
            if (this.managerMBean != null) {
                this.managerMBean.unregisterMBeanServer(this.mbeanServer);
            }
            if (this.healthCheck != null) {
                this.healthCheck.unregisterMBeanServer(this.mbeanServer);
            }
        }
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public MBeanServer getMbeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public FabricManager getManagerMBean() {
        return this.managerMBean;
    }

    public void setManagerMBean(FabricManager managerMBean) {
        this.managerMBean = managerMBean;
    }

    public String getDefaultRepo() {
        return this.defaultRepo;
    }

    public void setDefaultRepo(String defaultRepo) {
        this.defaultRepo = defaultRepo;
    }

    @Override
    public Container getCurrentContainer() {
        String name = this.getCurrentContainerName();
        return this.getContainer(name);
    }

    @Override
    public String getCurrentContainerName() {
        return System.getProperty("karaf.name");
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public Container[] getContainers() {
        try {
            HashMap<String, Container> containers = new HashMap<String, Container>();
            List configs = this.zooKeeper.getChildren(ZkPath.CONFIGS_CONTAINERS.getPath(new String[0]));
            for (String name : configs) {
                String parentId = this.getParentOf(name);
                if (parentId.isEmpty()) {
                    if (containers.containsKey(name)) continue;
                    ContainerImpl container = new ContainerImpl(null, name, this);
                    containers.put(name, container);
                    continue;
                }
                Container parent = (Container)containers.get(parentId);
                if (parent == null) {
                    parent = new ContainerImpl(null, parentId, this);
                    containers.put(parentId, parent);
                }
                ContainerImpl container = new ContainerImpl(parent, name, this);
                containers.put(name, container);
            }
            return containers.values().toArray(new Container[containers.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    private String getParentOf(String name) throws InterruptedException, KeeperException {
        if (this.zooKeeper != null) {
            try {
                return this.zooKeeper.getStringData(ZkPath.CONTAINER_PARENT.getPath(new String[]{name})).trim();
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (Throwable e) {
                LOGGER.debug("Failed to find parent " + name + ". This exception will be ignored.", e);
            }
        }
        return "";
    }

    @Override
    public Container getContainer(String name) {
        if (name == null) {
            return null;
        }
        try {
            Container parent = null;
            String parentId = this.getParentOf(name);
            if (parentId != null && !parentId.isEmpty()) {
                parent = this.getContainer(parentId);
            }
            return new ContainerImpl(parent, name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public void startContainer(String containerId) {
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.startContainer(container);
        }
    }

    public void startContainer(Container container) {
        LOGGER.info("Starting container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        if (!container.isAlive()) {
            provider.start(container);
        }
    }

    public void stopContainer(String containerId) {
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.stopContainer(container);
        }
    }

    public void stopContainer(Container container) {
        LOGGER.info("Stopping container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        if (container.isAlive()) {
            provider.stop(container);
        }
    }

    public void destroyContainer(String containerId) {
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.destroyContainer(container);
        }
    }

    public void destroyContainer(Container container) {
        String containerId = container.getId();
        LOGGER.info("Destroying container {}", (Object)containerId);
        ContainerProvider provider = this.getProvider(container);
        provider.destroy(container);
        try {
            for (Version version : this.getVersions()) {
                ZooKeeperUtils.deleteSafe((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version.getName(), containerId}));
            }
            ZooKeeperUtils.deleteSafe((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_PROVISION.getPath(new String[]{containerId}));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to cleanup container {} entries due to: {}. This will be ignored.", (Object)containerId, (Object)e.getMessage());
        }
    }

    protected ContainerProvider getProvider(Container container) {
        String type;
        CreateContainerMetadata<?> metadata = container.getMetadata();
        String string = type = metadata != null ? metadata.getCreateOptions().getProviderType() : null;
        if (type == null) {
            throw new UnsupportedOperationException("Container " + container.getId() + " has not been created using Fabric");
        }
        ContainerProvider provider = this.getProvider(type);
        if (provider == null) {
            throw new UnsupportedOperationException("Container provider " + type + " not supported");
        }
        return provider;
    }

    public static String getParentFromURI(URI uri) {
        String parent = uri.getHost();
        if (parent == null) {
            parent = uri.getSchemeSpecificPart();
        }
        return parent;
    }

    @Override
    public CreateContainerMetadata[] createContainers(CreateContainerOptions options) {
        if (options.getZookeeperUrl() == null && !options.isEnsembleServer()) {
            options.setZookeeperUrl(this.getZookeeperUrl());
        }
        if (options.getProxyUri() == null) {
            options.setProxyUri(this.getMavenRepoURI());
        }
        if (options.getJvmOpts() == null || options.getJvmOpts().length() == 0) {
            options.setJvmOpts(this.getDefaultJvmOptions());
        }
        if (options.isEnsembleServer() && (options.getZookeeperPassword() == null || options.getZookeeperPassword().isEmpty())) {
            options.setZookeeperPassword(ZooKeeperUtils.generatePassword());
        }
        try {
            ContainerProvider provider = this.getProvider(options.getProviderType());
            if (provider == null) {
                throw new FabricException("Unable to find a container provider supporting '" + options.getProviderType() + "'");
            }
            Container parent = options.getParent() != null ? this.getContainer(options.getParent()) : null;
            Set metadatas = provider.create(options);
            for (CreateContainerMetadata metadata : metadatas) {
                if (metadata.isSuccess()) {
                    if (!options.isEnsembleServer()) {
                        this.createContainerConfig(parent != null ? parent.getId() : "", metadata.getContainerName());
                        ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_METADATA.getPath(new String[]{metadata.getContainerName()}), (byte[])Base64Encoder.encode(ObjectUtils.toBytes(metadata)));
                        Map<String, String> configuration = metadata.getContainerConfiguration();
                        for (Map.Entry<String, String> entry : configuration.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_ENTRY.getPath(new String[]{metadata.getContainerName(), key}), (String)value);
                        }
                        if (options.getResolver() == null && this.zooKeeper.exists(ZkPath.CONTAINER_RESOLVER.getPath(new String[]{metadata.getContainerName()})) != null) {
                            options.setResolver(this.zooKeeper.getStringData(ZkPath.CONTAINER_RESOLVER.getPath(new String[]{metadata.getContainerName()})));
                        } else if (options.getResolver() == null) {
                            if (this.zooKeeper.exists(ZkPath.POLICIES.getPath(new String[]{"resolver"})) != null) {
                                options.setResolver(this.zooKeeper.getStringData(ZkPath.POLICIES.getPath(new String[]{"resolver"})));
                            } else {
                                options.setResolver("localhostname");
                            }
                        }
                        ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{metadata.getContainerName()}), (String)options.getResolver());
                    }
                    metadata.setContainer(new ContainerImpl(parent, metadata.getContainerName(), this));
                    ((ContainerImpl)metadata.getContainer()).setMetadata(metadata);
                    LOGGER.info("The container " + metadata.getContainerName() + " has been successfully created");
                    continue;
                }
                LOGGER.info("The creation of the container " + metadata.getContainerName() + " has failed", metadata.getFailure());
            }
            return metadatas.toArray(new CreateContainerMetadata[metadatas.size()]);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public ContainerProvider getProvider(String scheme) {
        return this.providers.get(scheme);
    }

    public Map<String, ContainerProvider> getProviders() {
        return Collections.unmodifiableMap(this.providers);
    }

    @Override
    public URI getMavenRepoURI() {
        URI uri = URI.create(this.defaultRepo);
        try {
            if (this.zooKeeper != null && this.zooKeeper.exists(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null) {
                String mavenRepo;
                List children = this.zooKeeper.getChildren(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}));
                if (children != null && !children.isEmpty()) {
                    Collections.sort(children);
                }
                if ((mavenRepo = ZooKeeperUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + (String)children.get(0)))) != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    @Override
    public URI getMavenRepoUploadURI() {
        URI uri = URI.create(this.defaultRepo);
        try {
            if (this.zooKeeper != null && this.zooKeeper.exists(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"})) != null) {
                String mavenRepo;
                List children = this.zooKeeper.getChildren(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}));
                if (children != null && !children.isEmpty()) {
                    Collections.sort(children);
                }
                if ((mavenRepo = ZooKeeperUtils.getSubstitutedPath((IZKClient)this.zooKeeper, (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}) + "/" + (String)children.get(0)))) != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public void registerProvider(String scheme, ContainerProvider provider) {
        this.providers.put(scheme, provider);
    }

    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        String scheme = (String)properties.get("fabric.container.protocol");
        this.registerProvider(scheme, provider);
    }

    public void unregisterProvider(String scheme) {
        if (this.providers != null && scheme != null) {
            this.providers.remove(scheme);
        }
    }

    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        String scheme = (String)properties.get("fabric.container.protocol");
        this.unregisterProvider(scheme);
    }

    @Override
    public String getZookeeperUrl() {
        return this.getZookeeperInfo("zookeeper.url");
    }

    @Override
    public String getZookeeperPassword() {
        return this.getZookeeperInfo("zookeeper.password");
    }

    public String getZookeeperInfo(String name) {
        String zooKeeperUrl = null;
        try {
            Map<String, String> zookeeperConfig;
            Map<String, Map<String, String>> configurations;
            Profile profile;
            Version defaultVersion;
            if (this.zooKeeper != null && this.zooKeeper.isConnected() && (defaultVersion = this.getDefaultVersion()) != null && (profile = this.getProfile(defaultVersion.getName(), "default")) != null && (configurations = profile.getConfigurations()) != null && (zookeeperConfig = configurations.get("org.fusesource.fabric.zookeeper")) != null) {
                zooKeeperUrl = ZooKeeperUtils.getSubstitutedData((IZKClient)this.zooKeeper, (String)zookeeperConfig.get(name));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (zooKeeperUrl == null) {
            try {
                Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                zooKeeperUrl = (String)config.getProperties().get(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zooKeeperUrl;
    }

    private void createContainerConfig(String parent, String name) {
        try {
            String configVersion = this.getDefaultVersion().getName();
            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{name}), (String)configVersion);
            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{configVersion, name}), (String)this.profile);
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_PARENT.getPath(new String[]{name}), parent, CreateMode.PERSISTENT);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getDefaultVersion() {
        try {
            String version = null;
            if (ZooKeeperUtils.exists((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0])) != null) {
                version = ZooKeeperUtils.get((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]));
            }
            if (version == null || version.isEmpty()) {
                version = "1.0";
                ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)version);
                ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSION.getPath(new String[]{version}), (String)null);
            }
            return new VersionImpl(version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setDefaultVersion(Version version) {
        this.setDefaultVersion(version.getName());
    }

    public void setDefaultVersion(String versionId) {
        try {
            ZooKeeperUtils.set((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)versionId);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version createVersion(String version) {
        try {
            this.zooKeeper.createWithParents(ZkPath.CONFIG_VERSION.getPath(new String[]{version}), CreateMode.PERSISTENT);
            this.zooKeeper.createWithParents(ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{version}), CreateMode.PERSISTENT);
            return new VersionImpl(version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version createVersion(Version parent, String toVersion) {
        return this.createVersion(parent.getName(), toVersion);
    }

    public Version createVersion(String parentVersionId, String toVersion) {
        try {
            ZooKeeperUtils.copy((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSION.getPath(new String[]{parentVersionId}), (String)ZkPath.CONFIG_VERSION.getPath(new String[]{toVersion}));
            return new VersionImpl(toVersion, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public void deleteVersion(String version) {
        try {
            this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_VERSION.getPath(new String[]{version}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version[] getVersions() {
        try {
            ArrayList<VersionImpl> versions = new ArrayList<VersionImpl>();
            List children = this.zooKeeper.getChildren(ZkPath.CONFIG_VERSIONS.getPath(new String[0]));
            for (String child : children) {
                versions.add(new VersionImpl(child, this));
            }
            Collections.sort(versions);
            return versions.toArray(new Version[versions.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getVersion(String name) {
        try {
            if (this.zooKeeper != null && this.zooKeeper.isConnected() && this.zooKeeper.exists(ZkPath.CONFIG_VERSION.getPath(new String[]{name})) == null) {
                throw new FabricException("Version '" + name + "' does not exist!");
            }
            return new VersionImpl(name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile[] getProfiles(String version) {
        try {
            ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
            List names = this.zooKeeper.getChildren(ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{version}));
            names.addAll(this.zooKeeper.getChildren(ZkPath.CONFIG_ENSEMBLE_PROFILES.getPath(new String[0])));
            for (String name : names) {
                profiles.add(new ProfileImpl(name, version, this));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile getProfile(String version, String name) {
        try {
            String path = ZkProfiles.getPath((String)version, (String)name);
            if (this.zooKeeper.exists(path) == null) {
                return null;
            }
            return new ProfileImpl(name, version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile createProfile(String version, String name) {
        try {
            ZooKeeperUtils.create((IZKClient)this.zooKeeper, (String)ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, name}));
            return new ProfileImpl(name, version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void deleteProfile(Profile profile) {
        this.deleteProfile(profile.getVersion(), profile.getId());
    }

    public void deleteProfile(String versionId, String profileId) {
        try {
            this.zooKeeper.deleteWithChildren(ZkProfiles.getPath((String)versionId, (String)profileId));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    protected ContainerTemplate getContainerTemplate(Container container, String jmxUser, String jmxPassword) {
        boolean cacheJmx = false;
        return new ContainerTemplate(container, jmxUser, jmxPassword, cacheJmx);
    }

    @Override
    public void setRequirements(FabricRequirements requirements) throws IOException {
        try {
            requirements.removeEmptyRequirements();
            String json = RequirementsJson.toJSON(requirements);
            this.zooKeeper.createOrSetWithParents(REQUIREMENTS_JSON_PATH, json, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public FabricRequirements getRequirements() {
        try {
            FabricRequirements answer = null;
            if (this.zooKeeper.exists(REQUIREMENTS_JSON_PATH) != null) {
                String json = this.zooKeeper.getStringData(REQUIREMENTS_JSON_PATH);
                answer = RequirementsJson.fromJSON(json);
            }
            if (answer == null) {
                answer = new FabricRequirements();
            }
            return answer;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public FabricStatus getFabricStatus() {
        return new FabricStatus(this);
    }

    @Override
    public PatchService getPatchService() {
        return new PatchServiceImpl(this, this.configurationAdmin);
    }

    @Override
    public String getDefaultJvmOptions() {
        try {
            if (this.zooKeeper.isConnected() && this.zooKeeper.exists(JVM_OPTIONS_PATH) != null) {
                return this.zooKeeper.getStringData(JVM_OPTIONS_PATH);
            }
            return "";
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setDefaultJvmOptions(String jvmOptions) {
        try {
            String opts = jvmOptions != null ? jvmOptions : "";
            this.zooKeeper.createOrSetWithParents(JVM_OPTIONS_PATH, opts, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }
}

