/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.utils;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ports {
    public static final int DEFAULT_HOST_SSH_PORT = 22;
    public static final int DEFAULT_KARAF_SSH_PORT = 8101;
    public static final int DEFAULT_ZOOKEEPER_SERVER_PORT = 2181;
    public static final int DEFAULT_ZOOKEEPER_PEER_PORT = 2888;
    public static final int DEFAULT_ZOOKEEPER_ELECTION_PORT = 3888;
    public static final int DEFAULT_RMI_SERVER_PORT = 44444;
    public static final int DEFAULT_RMI_REGISTRY_PORT = 1099;
    public static final int MIN_PORT_NUMBER = 0;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final String PORT_PATTERN = ":[\\d]*$";

    private Ports() {
    }

    public static int findPort(Map<String, List<Integer>> usedPorts, String ip, int port) {
        List<Integer> ports = usedPorts.get(ip);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(ip, ports);
        }
        while (true) {
            if (!ports.contains(port)) {
                ports.add(port);
                return port;
            }
            ++port;
        }
    }

    public static int findFreeLocalPort(List<Integer> usedPorts, int port, boolean checkIfAvailable) {
        while (true) {
            if (checkIfAvailable && !Ports.isPortFree(port)) {
                usedPorts.add(port);
            } else if (!usedPorts.contains(port)) {
                usedPorts.add(port);
                return port;
            }
            ++port;
        }
    }

    public static int mapPortToRange(int port, int minimumPort, int maximumPort) {
        if (maximumPort == 0) {
            maximumPort = 65535;
        }
        if (minimumPort >= maximumPort) {
            return port;
        }
        if (minimumPort == 0 && port <= minimumPort) {
            return port;
        }
        if (port >= minimumPort && port <= maximumPort) {
            return port;
        }
        return port % (maximumPort - minimumPort) + minimumPort;
    }

    public static int mapPortToRange(int port, String minimumPort, String maximumPort) {
        int min = 0;
        int max = 0;
        if (minimumPort != null) {
            try {
                min = Integer.parseInt(minimumPort);
            }
            catch (NumberFormatException e) {
                min = 0;
            }
        }
        if (maximumPort != null) {
            try {
                max = Integer.parseInt(maximumPort);
            }
            catch (NumberFormatException e) {
                max = 0;
            }
        }
        return Ports.mapPortToRange(port, min, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public static int extractPort(String address) {
        Pattern p = Pattern.compile(PORT_PATTERN);
        Matcher m = p.matcher(address);
        if (m.find()) {
            String match = m.group().substring(1);
            return Integer.parseInt(match);
        }
        return 0;
    }
}

