/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.regex.Pattern;
import jline.Terminal;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;
import org.jledit.ConsoleEditor;
import org.jledit.EditorFactory;
import org.jledit.utils.Closeables;

@Command(scope="shell", name="edit", description="Calls a text editor.")
public class EditAction
extends AbstractAction {
    private final Pattern URL_PATTERN = Pattern.compile("[^: ]+:[^ ]+");
    @Argument(index=0, name="url", description="The url of the resource to edit.", required=true, multiValued=false)
    private String url;
    private EditorFactory editorFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        URL u;
        URLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        String path = null;
        boolean isLocal = true;
        String sourceUrl = this.url;
        if (!this.URL_PATTERN.matcher(sourceUrl).matches()) {
            File f = new File(sourceUrl);
            sourceUrl = "file://" + f.getAbsolutePath();
        }
        if (!(u = new URL(sourceUrl)).getProtocol().equals("file")) {
            isLocal = false;
            try {
                connection = u.openConnection();
                is = connection.getInputStream();
            }
            catch (IOException ex) {
                System.out.println("Failed to open " + sourceUrl + " for reading.");
                return null;
            }
            try {
                os = connection.getOutputStream();
            }
            catch (IOException ex) {
                System.out.println("Failed to open " + sourceUrl + " for writing.");
                return null;
            }
            FileOutputStream fos = null;
            try {
                path = System.getProperty("karaf.data") + "/editor/" + UUID.randomUUID();
                File f = new File(path);
                if (!f.exists() && !f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                fos = new FileOutputStream(f);
                this.copy(is, fos);
                Closeables.closeQuitely((Closeable)fos);
            }
            catch (Exception ex) {
                System.out.println("Failed to copy resource from url:" + sourceUrl + " to tmp file: " + path + "  for editing.");
            }
            finally {
                Closeables.closeQuitely(fos);
            }
        } else {
            path = u.getFile();
        }
        ConsoleEditor editor = this.editorFactory.create(this.getTerminal());
        editor.setTitle("Karaf");
        editor.open(path, this.url);
        editor.setOpenEnabled(false);
        editor.start();
        if (!isLocal) {
            FileInputStream fis = new FileInputStream(path);
            try {
                this.copy(fis, os);
            }
            finally {
                Closeables.closeQuitely((Closeable)fis);
            }
        }
        if (is != null) {
            Closeables.closeQuitely((Closeable)is);
        }
        if (os != null) {
            Closeables.closeQuitely((Closeable)os);
        }
        return null;
    }

    private Terminal getTerminal() throws Exception {
        Object terminalObject = this.session.get(".jline.terminal");
        if (terminalObject instanceof Terminal) {
            return (Terminal)terminalObject;
        }
        throw new IllegalStateException("Could not get Terminal from CommandSession.");
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[16384];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            output.flush();
        }
    }

    public EditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorFactory(EditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }
}

