/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMap<K, V>
implements MultivaluedMap<K, V> {
    private boolean caseInsensitive;
    private Map<K, List<V>> m;

    public MetadataMap() {
        this.m = new LinkedHashMap<K, List<V>>();
    }

    public MetadataMap(int size) {
        this.m = new LinkedHashMap<K, List<V>>(size);
    }

    public MetadataMap(Map<K, List<V>> store) {
        this(store, false, false);
    }

    public MetadataMap(boolean readOnly, boolean caseInsensitive) {
        this(null, readOnly, caseInsensitive);
    }

    public MetadataMap(Map<K, List<V>> store, boolean readOnly, boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.m = new LinkedHashMap<K, List<V>>();
        if (store != null) {
            for (Map.Entry<K, List<V>> entry : store.entrySet()) {
                ArrayList values = new ArrayList(entry.getValue());
                this.m.put(entry.getKey(), readOnly ? Collections.unmodifiableList(values) : values);
            }
        }
        if (readOnly) {
            this.m = Collections.unmodifiableMap(this.m);
        }
    }

    public void add(K key, V value) {
        ArrayList<V> data = this.get(key);
        if (data == null) {
            data = new ArrayList<V>();
            this.m.put(key, data);
        }
        data.add(value);
    }

    public V getFirst(K key) {
        Object data = this.get(key);
        return data == null ? null : (V)data.get(0);
    }

    public void putSingle(K key, V value) {
        ArrayList<V> data = new ArrayList<V>();
        data.add(value);
        this.put(key, data);
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        if (!this.caseInsensitive) {
            return this.m.containsKey(key);
        }
        return this.getMatchingKey(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.m.entrySet();
    }

    public List<V> get(Object key) {
        if (!this.caseInsensitive) {
            return this.m.get(key);
        }
        K realKey = this.getMatchingKey(key);
        return realKey == null ? null : this.m.get(realKey);
    }

    private K getMatchingKey(Object key) {
        for (K entry : this.m.keySet()) {
            if (!entry.toString().equalsIgnoreCase(key.toString())) continue;
            return entry;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<K> keySet() {
        if (!this.caseInsensitive) {
            return this.m.keySet();
        }
        TreeSet set = new TreeSet(new KeyComparator());
        set.addAll(this.m.keySet());
        return set;
    }

    public List<V> put(K key, List<V> value) {
        K realKey = !this.caseInsensitive ? key : this.getMatchingKey(key);
        return this.m.put(realKey == null ? key : realKey, value);
    }

    public void putAll(Map<? extends K, ? extends List<V>> map) {
        if (!this.caseInsensitive) {
            this.m.putAll(map);
        } else {
            for (Map.Entry<K, List<V>> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public List<V> remove(Object key) {
        if (this.caseInsensitive) {
            K realKey = this.getMatchingKey(key);
            return this.m.remove(realKey == null ? key : realKey);
        }
        return this.m.remove(key);
    }

    public int size() {
        return this.m.size();
    }

    public Collection<List<V>> values() {
        return this.m.values();
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    public boolean equals(Object o) {
        return this.m.equals(o);
    }

    public String toString() {
        return this.m.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyComparator<K>
    implements Comparator<K> {
        private KeyComparator() {
        }

        @Override
        public int compare(K k1, K k2) {
            String s1 = k1.toString();
            String s2 = k2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

