/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.karaf.commands.internal.RegexUtil;
import org.apache.felix.gogo.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;

public abstract class AbstractRouteCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="route", description="The Camel route ID or a wildcard expression", required=true, multiValued=false)
    String route;
    @Argument(index=1, name="context", description="The Camel context name.", required=false, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public abstract void executeOnRoute(CamelContext var1, Route var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecute() throws Exception {
        List<Route> camelRoutes = this.camelController.getRoutes(this.context, RegexUtil.wildcardAsRegex(this.route));
        if (camelRoutes == null || camelRoutes.isEmpty()) {
            System.err.println("Camel routes using " + this.route + " not found.");
            return null;
        }
        for (Route camelRoute : camelRoutes) {
            CamelContext camelContext = camelRoute.getRouteContext().getCamelContext();
            ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(camelContext.getApplicationContextClassLoader());
            try {
                this.executeOnRoute(camelContext, camelRoute);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassloader);
            }
        }
        return null;
    }
}

