/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fusesource.common.util.Objects;
import org.fusesource.common.util.Strings;
import org.fusesource.fabric.fab.osgi.internal.VersionResolver;
import org.fusesource.fabric.fab.osgi.internal.Versions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class Bundles {
    public static boolean isInstalled(BundleContext bundleContext, String name, String version) {
        return Bundles.findBundle(bundleContext, name, version) != null;
    }

    public static Set<String> filterInstalled(BundleContext bundleContext, Collection<String> packages, VersionResolver resolver) {
        HashSet<String> rc = new HashSet<String>(packages);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (rc.isEmpty()) break;
            String value = (String)bundle.getHeaders().get("Export-Package");
            if (!Strings.notEmpty((String)value)) continue;
            Map<String, Map<String, String>> values = new Analyzer().parseHeader(value);
            for (String packageName : packages) {
                String importedVersion;
                String version;
                Map<String, String> map = values.get(packageName);
                if (map == null || (version = map.get("version")) == null || (importedVersion = resolver.resolvePackageVersion(packageName)) == null || !Versions.inRange(version, importedVersion)) continue;
                rc.remove(packageName);
            }
        }
        return rc;
    }

    public static Bundle findBundle(BundleContext bundleContext, String name, String version) {
        Bundle[] bundles;
        Version v = Versions.fromMavenVersion(version);
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            if (!Objects.equal((Object)bundle.getSymbolicName(), (Object)name) || !Objects.equal((Object)bundle.getVersion(), (Object)v)) continue;
            return bundle;
        }
        return null;
    }

    public static Set<Bundle> findBundles(BundleContext context, String name) {
        Bundle[] bundles;
        HashSet<Bundle> result = new HashSet<Bundle>();
        for (Bundle bundle : bundles = context.getBundles()) {
            if (!Objects.equal((Object)bundle.getSymbolicName(), (Object)name)) continue;
            result.add(bundle);
        }
        return result;
    }

    public static Bundle findOneBundle(BundleContext context, String name) {
        Set<Bundle> result = Bundles.findBundles(context, name);
        if (result.size() != 1) {
            throw new IllegalStateException(String.format("Expected exactly one bundle with symbolic name %s but we found %s bundles", name, result.size()));
        }
        return result.iterator().next();
    }

    public static boolean isFragment(Bundle bundle) {
        return Strings.notEmpty((String)((String)bundle.getHeaders().get("Fragment-Host")));
    }
}

