/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceListener.class);
    private Object listener;
    private String registerMethod;
    private String unregisterMethod;
    private ExtendedBlueprintContainer blueprintContainer;
    private List<Method> registerMethods;
    private List<Method> unregisterMethods;
    private boolean initialized = false;

    public void setListener(Object listener) {
        this.listener = listener;
    }

    public void setRegisterMethod(String method) {
        this.registerMethod = method;
    }

    public void setUnregisterMethod(String method) {
        this.unregisterMethod = method;
    }

    public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void register(Object service, Map properties) {
        this.init(service);
        this.invokeMethod(this.registerMethods, service, properties);
    }

    public void unregister(Object service, Map properties) {
        this.init(service);
        this.invokeMethod(this.unregisterMethods, service, properties);
    }

    private synchronized void init(Object service) {
        if (this.initialized) {
            return;
        }
        Class[] paramTypes = new Class[]{service != null ? service.getClass() : null, Map.class};
        Class<?> listenerClass = this.listener.getClass();
        if (this.registerMethod != null) {
            this.registerMethods = ReflectionUtils.findCompatibleMethods(listenerClass, this.registerMethod, paramTypes);
            if (this.registerMethods.size() == 0) {
                throw new ComponentDefinitionException("No matching methods found for listener registration method: " + this.registerMethod);
            }
            LOGGER.debug("Found register methods: {}", this.registerMethods);
        }
        if (this.unregisterMethod != null) {
            this.unregisterMethods = ReflectionUtils.findCompatibleMethods(listenerClass, this.unregisterMethod, paramTypes);
            if (this.unregisterMethods.size() == 0) {
                throw new ComponentDefinitionException("No matching methods found for listener unregistration method: " + this.unregisterMethod);
            }
            LOGGER.debug("Found unregister methods: {}", this.unregisterMethods);
        }
        this.initialized = true;
    }

    private void invokeMethod(List<Method> methods, Object service, Map properties) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (Method method : methods) {
            try {
                ReflectionUtils.invoke(this.blueprintContainer.getAccessControlContext(), method, this.listener, service, properties);
            }
            catch (Exception e) {
                LOGGER.error("Error calling listener method " + method, e);
            }
        }
    }
}

