/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils.threading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.blueprint.utils.threading.RWLock;
import org.apache.aries.blueprint.utils.threading.impl.Discardable;
import org.apache.aries.blueprint.utils.threading.impl.DiscardableCallable;
import org.apache.aries.blueprint.utils.threading.impl.DiscardableRunnable;
import org.apache.aries.blueprint.utils.threading.impl.WrappedFuture;
import org.apache.aries.blueprint.utils.threading.impl.WrappedScheduledFuture;
import org.apache.aries.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledExecutorServiceWrapper
implements ScheduledExecutorService,
SingleServiceTracker.SingleServiceListener {
    private final AtomicReference<ScheduledExecutorService> _current = new AtomicReference();
    private SingleServiceTracker<ScheduledExecutorService> _tracked;
    private final AtomicReference<ScheduledExecutorService> _default = new AtomicReference();
    private final AtomicBoolean _shutdown = new AtomicBoolean();
    private final Queue<Discardable<Runnable>> _unprocessedWork = new LinkedBlockingQueue<Discardable<Runnable>>();
    private final RWLock _lock = new RWLock();
    private final AtomicInteger _invokeEntryCount = new AtomicInteger();
    private final ScheduledExecutorServiceFactory _factory;
    private final String _name;

    public ScheduledExecutorServiceWrapper(BundleContext context, String name, ScheduledExecutorServiceFactory sesf) {
        this._name = name;
        this._factory = sesf;
        try {
            this._tracked = new SingleServiceTracker<ScheduledExecutorService>(context, ScheduledExecutorService.class, "(aries.blueprint.poolName=" + this._name + ")", this);
            this._tracked.open();
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (this._current.get() == null) {
            this._default.set(this._factory.create(name));
            if (!this._current.compareAndSet(null, this._default.get())) {
                ((ScheduledExecutorService)this._default.getAndSet(null)).shutdown();
            }
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeLeftToWait = unit.toMillis(timeout);
        long pausePeriod = timeLeftToWait;
        if (pausePeriod > 1000L) {
            pausePeriod = 1000L;
        }
        while (!this._unprocessedWork.isEmpty() && this._invokeEntryCount.get() > 0 && timeLeftToWait > 0L) {
            Thread.sleep(pausePeriod);
            if ((timeLeftToWait -= pausePeriod) >= pausePeriod) continue;
            pausePeriod = timeLeftToWait;
        }
        return this._unprocessedWork.isEmpty() && this._invokeEntryCount.get() > 0;
    }

    @Override
    public <T> List<Future<T>> invokeAll(final Collection<? extends Callable<T>> tasks) throws InterruptedException {
        try {
            return (List)this.runUnlessShutdown(new Callable<List<Future<T>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<Future<T>> call() throws Exception {
                    ScheduledExecutorServiceWrapper.this._invokeEntryCount.incrementAndGet();
                    try {
                        List list = ((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).invokeAll(tasks);
                        return list;
                    }
                    finally {
                        ScheduledExecutorServiceWrapper.this._invokeEntryCount.decrementAndGet();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(final Collection<? extends Callable<T>> tasks, final long timeout, final TimeUnit unit) throws InterruptedException {
        try {
            return (List)this.runUnlessShutdown(new Callable<List<Future<T>>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<Future<T>> call() throws Exception {
                    ScheduledExecutorServiceWrapper.this._invokeEntryCount.incrementAndGet();
                    try {
                        List list = ((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).invokeAll(tasks, timeout, unit);
                        return list;
                    }
                    finally {
                        ScheduledExecutorServiceWrapper.this._invokeEntryCount.decrementAndGet();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public <T> T invokeAny(final Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.runUnlessShutdown(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    ScheduledExecutorServiceWrapper.this._invokeEntryCount.incrementAndGet();
                    try {
                        Object t = ((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).invokeAny(tasks);
                        return t;
                    }
                    finally {
                        ScheduledExecutorServiceWrapper.this._invokeEntryCount.decrementAndGet();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public <T> T invokeAny(final Collection<? extends Callable<T>> tasks, final long timeout, final TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.runUnlessShutdown(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    ScheduledExecutorServiceWrapper.this._invokeEntryCount.incrementAndGet();
                    try {
                        Object t = ((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).invokeAny(tasks, timeout, unit);
                        return t;
                    }
                    finally {
                        ScheduledExecutorServiceWrapper.this._invokeEntryCount.decrementAndGet();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public boolean isShutdown() {
        return this._shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        if (this.isShutdown()) {
            return this._unprocessedWork.isEmpty();
        }
        return false;
    }

    @Override
    public void shutdown() {
        this._lock.runWriteOperation(new Runnable(){

            public void run() {
                ScheduledExecutorServiceWrapper.this._shutdown.set(true);
                ScheduledExecutorService s = (ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._default.get();
                if (s != null) {
                    s.shutdown();
                }
            }
        });
    }

    @Override
    public List<Runnable> shutdownNow() {
        try {
            return this._lock.runWriteOperation(new Callable<List<Runnable>>(){

                @Override
                public List<Runnable> call() {
                    ScheduledExecutorServiceWrapper.this._shutdown.set(true);
                    ScheduledExecutorService s = (ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._default.get();
                    if (s != null) {
                        s.shutdownNow();
                    }
                    ArrayList<Runnable> runnables = new ArrayList<Runnable>();
                    for (Discardable r : ScheduledExecutorServiceWrapper.this._unprocessedWork) {
                        Runnable newRunnable = (Runnable)r.discard();
                        if (newRunnable == null) continue;
                        runnables.add(newRunnable);
                    }
                    return runnables;
                }
            });
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public <T> Future<T> submit(final Callable<T> task) {
        try {
            return (Future)this.runUnlessShutdown(new Callable<Future<T>>(){

                @Override
                public Future<T> call() throws Exception {
                    DiscardableCallable t = new DiscardableCallable(task, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedFuture(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).submit(t), t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public Future<?> submit(final Runnable task) {
        try {
            return (Future)this.runUnlessShutdown(new Callable<Future<?>>(){

                @Override
                public Future<?> call() {
                    DiscardableRunnable t = new DiscardableRunnable(task, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedFuture(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).submit(t), t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public <T> Future<T> submit(final Runnable task, final T result) {
        try {
            return (Future)this.runUnlessShutdown(new Callable<Future<T>>(){

                @Override
                public Future<T> call() {
                    DiscardableRunnable t = new DiscardableRunnable(task, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedFuture<Object>(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).submit(t, result), t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public void execute(final Runnable command) {
        try {
            this.runUnlessShutdown(new Callable<Object>(){

                @Override
                public Object call() {
                    DiscardableRunnable t = new DiscardableRunnable(command, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        ((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).execute(t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public ScheduledFuture<?> schedule(final Runnable command, final long delay, final TimeUnit unit) {
        try {
            return (ScheduledFuture)this.runUnlessShutdown(new Callable<ScheduledFuture<?>>(){

                @Override
                public ScheduledFuture<?> call() {
                    DiscardableRunnable t = new DiscardableRunnable(command, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedScheduledFuture(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).schedule(t, delay, unit), t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public <V> ScheduledFuture<V> schedule(final Callable<V> callable, final long delay, final TimeUnit unit) {
        try {
            return (ScheduledFuture)this.runUnlessShutdown(new Callable<ScheduledFuture<V>>(){

                @Override
                public ScheduledFuture<V> call() {
                    DiscardableCallable c = new DiscardableCallable(callable, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedScheduledFuture(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).schedule(c, delay, unit), c);
                    }
                    catch (RuntimeException e) {
                        c.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(final Runnable command, final long initialDelay, final long period, final TimeUnit unit) {
        try {
            return (ScheduledFuture)this.runUnlessShutdown(new Callable<ScheduledFuture<?>>(){

                @Override
                public ScheduledFuture<?> call() {
                    DiscardableRunnable t = new DiscardableRunnable(command, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedScheduledFuture(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).scheduleAtFixedRate(t, initialDelay, period, unit), t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(final Runnable command, final long initialDelay, final long delay, final TimeUnit unit) {
        try {
            return (ScheduledFuture)this.runUnlessShutdown(new Callable<ScheduledFuture<?>>(){

                @Override
                public ScheduledFuture<?> call() {
                    DiscardableRunnable t = new DiscardableRunnable(command, ScheduledExecutorServiceWrapper.this._unprocessedWork);
                    try {
                        return new WrappedScheduledFuture(((ScheduledExecutorService)ScheduledExecutorServiceWrapper.this._current.get()).scheduleWithFixedDelay(t, initialDelay, delay, unit), t);
                    }
                    catch (RuntimeException e) {
                        t.discard();
                        throw e;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public void serviceFound() {
        ScheduledExecutorService s = this._default.get();
        if (this._current.compareAndSet(s, this._tracked.getService()) && s != null && this._default.compareAndSet(s, null)) {
            s.shutdown();
        }
    }

    @Override
    public void serviceLost() {
        ScheduledExecutorService s = this._default.get();
        if (s == null && this._default.compareAndSet(null, s = this._factory.create(this._name))) {
            this._current.set(s);
        }
    }

    @Override
    public void serviceReplaced() {
        this._current.set(this._tracked.getService());
    }

    private <T> T runUnlessShutdown(final Callable<T> call) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this._lock.runReadOperation(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    if (ScheduledExecutorServiceWrapper.this.isShutdown()) {
                        throw new RejectedExecutionException();
                    }
                    return call.call();
                }
            });
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RejectedExecutionException();
        }
    }

    public static interface ScheduledExecutorServiceFactory {
        public ScheduledExecutorService create(String var1);
    }
}

