/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.commands;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableIdRefMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.karaf.shell.console.commands.BlueprintCommand;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceHandler
implements org.apache.aries.blueprint.NamespaceHandler {
    public static final String ID = "id";
    public static final String ACTION = "action";
    public static final String ACTION_ID = "actionId";
    public static final String COMMAND_BUNDLE = "command-bundle";
    public static final String NAME = "name";
    public static final String COMMAND = "command";
    public static final String COMPLETERS = "completers";
    public static final String OPTIONAL_COMPLETERS = "optional-completers";
    public static final String OPTIONAL_COMPLETERS_PROPERTY = "optionalCompleters";
    public static final String BEAN = "bean";
    public static final String REF = "ref";
    public static final String NULL = "null";
    public static final String MAP = "map";
    public static final String BLUEPRINT_CONTAINER = "blueprintContainer";
    public static final String BLUEPRINT_CONVERTER = "blueprintConverter";
    public static final String SHELL_NAMESPACE_1_0_0 = "http://karaf.apache.org/xmlns/shell/v1.0.0";
    public static final String SHELL_NAMESPACE_1_1_0 = "http://karaf.apache.org/xmlns/shell/v1.1.0";
    private int nameCounter = 0;

    @Override
    public URL getSchemaLocation(String namespace) {
        if (SHELL_NAMESPACE_1_0_0.equals(namespace)) {
            return this.getClass().getResource("karaf-shell-1.0.0.xsd");
        }
        if (SHELL_NAMESPACE_1_1_0.equals(namespace)) {
            return this.getClass().getResource("karaf-shell-1.1.0.xsd");
        }
        return this.getClass().getResource("karaf-shell-1.1.0.xsd");
    }

    @Override
    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(BlueprintCommand.class));
    }

    @Override
    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        throw new ComponentDefinitionException("Bad xml syntax: node decoration is not supported");
    }

    @Override
    public Metadata parse(Element element, ParserContext context) {
        if (NamespaceHandler.nodeNameEquals(element, COMMAND_BUNDLE)) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                this.parseChildElement(childElement, context);
            }
            return null;
        }
        throw new IllegalStateException("Unexpected element " + element.getNodeName());
    }

    private void parseChildElement(Element element, ParserContext context) {
        if (NamespaceHandler.nodeNameEquals(element, COMMAND)) {
            this.parseCommand(element, context);
        }
    }

    private void parseCommand(Element element, ParserContext context) {
        String function;
        String scope;
        MutableBeanMetadata command = context.createMetadata(MutableBeanMetadata.class);
        command.setRuntimeClass(BlueprintCommand.class);
        command.addProperty(BLUEPRINT_CONTAINER, this.createRef(context, BLUEPRINT_CONTAINER));
        command.addProperty(BLUEPRINT_CONVERTER, this.createRef(context, BLUEPRINT_CONVERTER));
        String location = element.getAttribute(NAME);
        location = location.replace('/', ':');
        if (location.lastIndexOf(58) >= 0) {
            scope = location.substring(0, location.lastIndexOf(58));
            function = location.substring(location.lastIndexOf(58) + 1);
        } else {
            scope = "";
            function = location;
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (NamespaceHandler.nodeNameEquals(childElement, ACTION)) {
                MutableBeanMetadata action = this.parseAction(context, command, childElement);
                action.setId(this.getName());
                context.getComponentDefinitionRegistry().registerComponentDefinition(action);
                command.addProperty(ACTION_ID, this.createIdRef(context, action.getId()));
                continue;
            }
            if (NamespaceHandler.nodeNameEquals(childElement, COMPLETERS)) {
                command.addProperty(COMPLETERS, this.parseCompleters(context, command, childElement));
                continue;
            }
            if (NamespaceHandler.nodeNameEquals(childElement, OPTIONAL_COMPLETERS)) {
                command.addProperty(OPTIONAL_COMPLETERS_PROPERTY, this.parseOptionalCompleters(context, command, childElement));
                continue;
            }
            throw new ComponentDefinitionException("Bad xml syntax: unknown element '" + childElement.getNodeName() + "'");
        }
        MutableServiceMetadata commandService = context.createMetadata(MutableServiceMetadata.class);
        commandService.setActivation(2);
        commandService.setId(this.getName());
        commandService.setAutoExport(4);
        commandService.setServiceComponent(command);
        commandService.addServiceProperty(this.createStringValue(context, "osgi.command.scope"), this.createStringValue(context, scope));
        commandService.addServiceProperty(this.createStringValue(context, "osgi.command.function"), this.createStringValue(context, function));
        context.getComponentDefinitionRegistry().registerComponentDefinition(commandService);
    }

    private MutableBeanMetadata parseAction(ParserContext context, ComponentMetadata enclosingComponent, Element element) {
        MutableBeanMetadata action = context.createMetadata(MutableBeanMetadata.class);
        action.setActivation(2);
        action.setScope("prototype");
        action.setClassName(element.getAttribute("class"));
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            if (NamespaceHandler.nodeNameEquals(childElement, "argument")) {
                action.addArgument(context.parseElement(BeanArgument.class, enclosingComponent, childElement));
                continue;
            }
            if (!NamespaceHandler.nodeNameEquals(childElement, "property")) continue;
            action.addProperty(context.parseElement(BeanProperty.class, enclosingComponent, childElement));
        }
        return action;
    }

    private Metadata parseOptionalCompleters(ParserContext context, ComponentMetadata enclosingComponent, Element element) {
        Metadata metadata = context.parseElement(MapMetadata.class, context.getEnclosingComponent(), element);
        return metadata;
    }

    private Metadata parseCompleters(ParserContext context, ComponentMetadata enclosingComponent, Element element) {
        MutableCollectionMetadata collection = context.createMetadata(MutableCollectionMetadata.class);
        collection.setCollectionClass(List.class);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Metadata metadata;
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            if (NamespaceHandler.nodeNameEquals(child, REF)) {
                metadata = context.parseElement(RefMetadata.class, context.getEnclosingComponent(), (Element)child);
            } else if (NamespaceHandler.nodeNameEquals(child, NULL)) {
                metadata = context.parseElement(NullMetadata.class, context.getEnclosingComponent(), (Element)child);
            } else if (NamespaceHandler.nodeNameEquals(child, BEAN)) {
                metadata = context.parseElement(BeanMetadata.class, enclosingComponent, (Element)child);
            } else {
                throw new IllegalStateException("Unexpected element " + child.getNodeName());
            }
            collection.addValue(metadata);
        }
        return collection;
    }

    private ValueMetadata createStringValue(ParserContext context, String str) {
        MutableValueMetadata value = context.createMetadata(MutableValueMetadata.class);
        value.setStringValue(str);
        return value;
    }

    private RefMetadata createRef(ParserContext context, String id) {
        MutableRefMetadata idref = context.createMetadata(MutableRefMetadata.class);
        idref.setComponentId(id);
        return idref;
    }

    private IdRefMetadata createIdRef(ParserContext context, String id) {
        MutableIdRefMetadata idref = context.createMetadata(MutableIdRefMetadata.class);
        idref.setComponentId(id);
        return idref;
    }

    public synchronized String getName() {
        return "shell-" + ++this.nameCounter;
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }
}

