/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.DelayedStarted;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.local.AgentImpl;
import org.fusesource.jansi.AnsiConsole;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleFactory.class);
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private BundleContext bundleContext;
    private CommandProcessor commandProcessor;
    private ThreadIO threadIO;
    private TerminalFactory terminalFactory;
    Console console;
    private boolean start;
    private ServiceRegistration registration;
    private SshAgent local;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public synchronized void registerCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = commandProcessor;
        this.start();
    }

    public synchronized void unregisterCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = null;
        this.stop();
    }

    public void setThreadIO(ThreadIO threadIO) {
        this.threadIO = threadIO;
    }

    public void setTerminalFactory(TerminalFactory terminalFactory) {
        this.terminalFactory = terminalFactory;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    protected void start() throws Exception {
        if (this.start) {
            Subject subject = new Subject();
            String user = "karaf";
            subject.getPrincipals().add(new UserPrincipal("karaf"));
            JaasHelper.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConsoleFactory.this.doStart("karaf");
                    return null;
                }
            });
        }
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) throws Exception {
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            methods[i].setAccessible(true);
            return methods[i].invoke(o, params);
        }
        return null;
    }

    private static <T> T unwrapBIS(T stream) {
        try {
            return (T)ConsoleFactory.invokePrivateMethod(stream, "getInIfOpen", null);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    protected void doStart(String user) throws Exception {
        String agentId = this.startAgent(user);
        final Terminal terminal = this.terminalFactory.getTerminal();
        InputStream unwrappedIn = ConsoleFactory.unwrapBIS(ConsoleFactory.unwrap(System.in));
        InputStream in = terminal.wrapInIfNeeded(unwrappedIn);
        PrintStream out = ConsoleFactory.unwrap(System.out);
        PrintStream err = ConsoleFactory.unwrap(System.err);
        Runnable callback = new Runnable(){

            public void run() {
                try {
                    ConsoleFactory.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        String ctype = System.getenv("LC_CTYPE");
        String encoding = ctype;
        encoding = encoding != null && encoding.indexOf(46) > 0 ? encoding.substring(encoding.indexOf(46) + 1) : System.getProperty("input.encoding", Charset.defaultCharset().name());
        this.console = new Console(this.commandProcessor, this.threadIO, in, ConsoleFactory.wrap(out), ConsoleFactory.wrap(err), terminal, encoding, callback);
        CommandSession session = this.console.getSession();
        session.put("USER", user);
        session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        session.put("#LINES", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getHeight());
            }
        });
        session.put("#COLUMNS", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getWidth());
            }
        });
        if (ctype != null) {
            session.put("LC_CTYPE", ctype);
        }
        session.put(".jline.terminal", terminal);
        session.put("SSH_AUTH_SOCK", agentId);
        boolean delayconsole = Boolean.parseBoolean(System.getProperty("karaf.delay.console"));
        if (delayconsole) {
            new DelayedStarted(this.console, this.bundleContext, unwrappedIn).start();
        } else {
            new Thread((Runnable)this.console, "Karaf Shell Console Thread").start();
        }
    }

    protected String startAgent(String user) {
        try {
            this.local = new AgentImpl();
            URL url = this.bundleContext.getBundle().getResource("karaf.key");
            InputStream is = url.openStream();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            this.local.addIdentity(keyPair, "karaf");
            String agentId = "local:" + user;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("id", agentId);
            this.registration = this.bundleContext.registerService(SshAgent.class.getName(), (Object)this.local, properties);
            return agentId;
        }
        catch (Throwable e) {
            LOGGER.warn("Error starting ssh agent for local console", e);
            return null;
        }
    }

    protected void stop() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.console != null) {
            this.console.close(false);
        }
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }
}

