/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.util.Buffer;

public abstract class AbstractServerChannel
extends AbstractChannel {
    protected boolean exitStatusSent;

    public OpenFuture open(int recipient, int rwsize, int rmpsize, Buffer buffer) {
        this.recipient = recipient;
        this.remoteWindow.init(rwsize, rmpsize);
        this.configureWindow();
        return this.doInit(buffer);
    }

    public void handleOpenSuccess(int recipient, int rwsize, int rmpsize, Buffer buffer) throws IOException {
        throw new IllegalStateException();
    }

    public void handleOpenFailure(Buffer buffer) {
        throw new IllegalStateException();
    }

    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        f.setOpened();
        return f;
    }

    protected void sendExitStatus(int v) throws IOException {
        if (!this.exitStatusSent) {
            this.exitStatusSent = true;
            this.log.info("Send SSH_MSG_CHANNEL_REQUEST exit-status on channel {}", this.id);
            Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_REQUEST, 0);
            buffer.putInt(this.recipient);
            buffer.putString("exit-status");
            buffer.putByte((byte)0);
            buffer.putInt(v);
            this.session.writePacket(buffer);
        }
    }
}

