/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceServletHandler;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpServiceContext
extends ServletContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceContext.class);
    private final Map<String, Object> m_attributes;
    private final HttpContext m_httpContext;
    private final AccessControlContext m_accessControllerContext;

    HttpServiceContext(HandlerContainer parent, Map<String, String> initParams, Map<String, Object> attributes, String contextName, HttpContext httpContext, AccessControlContext accessControllerContext) {
        super(parent, "/" + contextName, 3);
        this.getInitParams().putAll(initParams);
        this.m_attributes = attributes;
        this.m_httpContext = httpContext;
        this.m_accessControllerContext = accessControllerContext;
        this._scontext = new SContext();
        this.setServletHandler(new HttpServiceServletHandler(httpContext));
        this.setErrorHandler((ErrorHandler)new ErrorPageErrorHandler());
    }

    protected void doStart() throws Exception {
        if (this.m_attributes != null) {
            for (Map.Entry<String, Object> attribute : this.m_attributes.entrySet()) {
                this._scontext.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        super.doStart();
        LOG.debug("Started servlet context for http context [" + this.m_httpContext + "]");
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopped servlet context for http context [" + this.m_httpContext + "]");
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOG.debug("Handling request for [" + target + "] using http context [" + this.m_httpContext + "]");
        super.doHandle(target, baseRequest, request, response);
    }

    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
        if (this._sessionHandler != null) {
            for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
                EventListener listener = eventListeners[i];
                if (!(listener instanceof HttpSessionActivationListener) && !(listener instanceof HttpSessionAttributeListener) && !(listener instanceof HttpSessionBindingListener) && !(listener instanceof HttpSessionListener)) continue;
                this._sessionHandler.addEventListener(listener);
            }
        }
    }

    public void addEventListener(final EventListener listener) {
        super.addEventListener(listener);
        if (this.isStarted() && listener instanceof ServletContextListener) {
            try {
                ContextClassLoaderUtils.doWithClassLoader(this.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() {
                        ((ServletContextListener)listener).contextInitialized(new ServletContextEvent((ServletContext)HttpServiceContext.this._scontext));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOG.error("Ignored exception during listener registration", (Throwable)e);
            }
        }
    }

    protected boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath((String)target);
        }
        return StringUtil.startsWithIgnoreCase((String)target, (String)"/web-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/meta-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-inf") || StringUtil.startsWithIgnoreCase((String)target, (String)"/osgi-opt");
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "httpContext=" + this.m_httpContext + "}";
    }

    public class SContext
    extends ServletContextHandler.Context {
        public SContext() {
            super((ServletContextHandler)HttpServiceContext.this);
        }

        public String getRealPath(String path) {
            File file;
            String fileName;
            String protocol;
            URL resource;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting real path: [" + path + "]");
            }
            if ((resource = this.getResource(path)) != null && (protocol = resource.getProtocol()).equals("file") && (fileName = resource.getFile()) != null && (file = new File(fileName)).exists()) {
                String realPath = file.getAbsolutePath();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found real path: [" + realPath + "]");
                }
                return realPath;
            }
            return null;
        }

        public URL getResource(String path) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting resource: [" + path + "]");
            }
            URL resource = null;
            try {
                resource = new URL(path);
                LOG.debug("resource: [" + path + "] is already a URL, returning");
                return resource;
            }
            catch (MalformedURLException e) {
                LOG.debug("not a URL or invalid URL: [" + path + "], treating as a file path");
                final String p = path != null && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                try {
                    resource = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                        @Override
                        public URL run() throws Exception {
                            return HttpServiceContext.this.m_httpContext.getResource(p);
                        }
                    }, HttpServiceContext.this.m_accessControllerContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource: " + resource);
                    }
                }
                catch (PrivilegedActionException e2) {
                    LOG.warn("Unauthorized access: " + e2.getMessage());
                }
                return resource;
            }
        }

        public InputStream getResourceAsStream(String path) {
            final URL url = this.getResource(path);
            if (url != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws Exception {
                            try {
                                return url.openStream();
                            }
                            catch (IOException e) {
                                LOG.warn("URL canot be accessed: " + e.getMessage());
                                return null;
                            }
                        }
                    }, HttpServiceContext.this.m_accessControllerContext);
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                }
            }
            return null;
        }

        public Set getResourcePaths(final String path) {
            if (HttpServiceContext.this.m_httpContext instanceof WebContainerContext) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getting resource paths for : [" + path + "]");
                }
                try {
                    Set<String> paths = AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                        @Override
                        public Set<String> run() throws Exception {
                            return ((WebContainerContext)HttpServiceContext.this.m_httpContext).getResourcePaths(path);
                        }
                    }, HttpServiceContext.this.m_accessControllerContext);
                    if (paths == null) {
                        return null;
                    }
                    HashSet<String> slashedPaths = new HashSet<String>();
                    for (String foundPath : paths) {
                        if (foundPath == null) continue;
                        if (foundPath.trim().startsWith("/")) {
                            slashedPaths.add(foundPath.trim());
                            continue;
                        }
                        slashedPaths.add("/" + foundPath.trim());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource paths: " + paths);
                    }
                    return slashedPaths;
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                    return null;
                }
            }
            return super.getResourcePaths(path);
        }

        public String getMimeType(String name) {
            String mime;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting mime type for: [" + name + "]");
            }
            if ((mime = HttpServiceContext.this.m_httpContext.getMimeType(name)) != null) {
                return mime;
            }
            return super.getMimeType(name);
        }
    }
}

