/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.main.BootstrapLogManager;
import org.apache.karaf.main.Lock;
import org.apache.karaf.main.ShutdownCallback;
import org.apache.karaf.main.SimpleFileLock;
import org.apache.karaf.main.StartLevelListener;
import org.apache.karaf.main.StartupListener;
import org.apache.karaf.main.StringMap;
import org.apache.karaf.main.Utils;
import org.apache.karaf.main.util.FileLockUtils;
import org.apache.karaf.main.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static final String SYSTEM_PROPERTIES_FILE_NAME = "system.properties";
    public static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    public static final String STARTUP_PROPERTIES_FILE_NAME = "startup.properties";
    public static final String PROPERTY_AUTO_INSTALL = "karaf.auto.install";
    public static final String PROPERTY_AUTO_START = "karaf.auto.start";
    public static final String PROP_KARAF_HOME = "karaf.home";
    public static final String ENV_KARAF_HOME = "KARAF_HOME";
    public static final String PROP_KARAF_BASE = "karaf.base";
    public static final String ENV_KARAF_BASE = "KARAF_BASE";
    public static final String PROP_KARAF_DATA = "karaf.data";
    public static final String ENV_KARAF_DATA = "KARAF_DATA";
    public static final String PROP_KARAF_INSTANCES = "karaf.instances";
    public static final String ENV_KARAF_INSTANCES = "KARAF_INSTANCES";
    public static final String PROP_KARAF_VERSION = "karaf.version";
    public static final String BUNDLE_LOCATIONS = "bundle.locations";
    public static final String PROPERTY_CONVERT_TO_MAVEN_URL = "karaf.maven.convert";
    public static final String PROPERTY_USE_LOCK = "karaf.lock";
    public static final String PROPERTY_LOCK_CLASS = "karaf.lock.class";
    public static final String PROPERTY_LOCK_DELAY = "karaf.lock.delay";
    public static final String PROPERTY_LOCK_LEVEL = "karaf.lock.level";
    public static final String DEFAULT_REPO = "karaf.default.repository";
    public static final String KARAF_FRAMEWORK = "karaf.framework";
    public static final String KARAF_FRAMEWORK_FACTORY = "karaf.framework.factory";
    public static final String KARAF_SHUTDOWN_TIMEOUT = "karaf.shutdown.timeout";
    public static final String KARAF_SHUTDOWN_PORT = "karaf.shutdown.port";
    public static final String KARAF_SHUTDOWN_HOST = "karaf.shutdown.host";
    public static final String KARAF_SHUTDOWN_PORT_FILE = "karaf.shutdown.port.file";
    public static final String KARAF_SHUTDOWN_COMMAND = "karaf.shutdown.command";
    public static final String KARAF_SHUTDOWN_PID_FILE = "karaf.shutdown.pid.file";
    public static final String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";
    public static final String PROPERTY_LOCK_CLASS_DEFAULT = SimpleFileLock.class.getName();
    public static final String INCLUDES_PROPERTY = "${includes}";
    public static final String OPTIONALS_PROPERTY = "${optionals}";
    public static final String KARAF_ACTIVATOR = "Karaf-Activator";
    public static final String SECURITY_PROVIDERS = "org.apache.karaf.security.providers";
    public static final String KARAF_STARTUP_MESSAGE = "karaf.startup.message";
    private static final String KARAF_DELAY_CONSOLE = "karaf.delay.console";
    public static final String DEFAULT_LOCK_DELAY = "1000";
    public static final String OVERRIDE_PREFIX = "karaf.override.";
    Logger LOG = Logger.getLogger(this.getClass().getName());
    private File karafHome;
    private File karafBase;
    private File karafData;
    private File karafInstances;
    private java.util.Properties configProps = null;
    private Framework framework = null;
    private final String[] args;
    private int exitCode;
    private Lock lock;
    private int defaultStartLevel = 100;
    private int lockStartLevel = 1;
    private int lockDelay = Integer.parseInt("1000");
    private int shutdownTimeout = 300000;
    private boolean exiting = false;
    private ShutdownCallback shutdownCallback;
    private List<BundleActivator> karafActivators = new ArrayList<BundleActivator>();
    private Object startLevelLock = new Object();
    private StartLevelListener startLevelListener;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private Random random = null;
    private ServerSocket shutdownSocket;

    public Main(String[] args) {
        this.args = args;
    }

    public void setShutdownCallback(ShutdownCallback shutdownCallback) {
        this.shutdownCallback = shutdownCallback;
    }

    public void launch() throws Exception {
        this.karafHome = Utils.getKarafHome();
        this.karafBase = Utils.getKarafDirectory(PROP_KARAF_BASE, ENV_KARAF_BASE, this.karafHome, false, true);
        this.karafData = Utils.getKarafDirectory(PROP_KARAF_DATA, ENV_KARAF_DATA, new File(this.karafBase, "data"), true, true);
        this.karafInstances = Utils.getKarafDirectory(PROP_KARAF_INSTANCES, ENV_KARAF_INSTANCES, new File(this.karafHome, "instances"), false, false);
        Package p = Package.getPackage("org.apache.karaf.main");
        if (p != null && p.getImplementationVersion() != null) {
            System.setProperty(PROP_KARAF_VERSION, p.getImplementationVersion());
        }
        System.setProperty(PROP_KARAF_HOME, this.karafHome.getPath());
        System.setProperty(PROP_KARAF_BASE, this.karafBase.getPath());
        System.setProperty(PROP_KARAF_DATA, this.karafData.getPath());
        System.setProperty(PROP_KARAF_INSTANCES, this.karafInstances.getPath());
        Main.loadSystemProperties(this.karafBase);
        this.updateInstancePid();
        this.configProps = this.loadConfigProperties();
        BootstrapLogManager.setProperties(this.configProps);
        this.LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        Main.copySystemProperties(this.configProps);
        boolean delayConsoleStart = Boolean.parseBoolean(this.configProps.getProperty(KARAF_DELAY_CONSOLE, "false"));
        System.setProperty(KARAF_DELAY_CONSOLE, new Boolean(delayConsoleStart).toString());
        if (delayConsoleStart) {
            System.out.println(this.configProps.getProperty(KARAF_STARTUP_MESSAGE, "Apache Karaf starting up. Press Enter to open shell now ..."));
        }
        ClassLoader classLoader = this.createClassLoader(this.configProps);
        Main.processSecurityProperties(this.configProps);
        if (this.configProps.getProperty("org.osgi.framework.storage") == null) {
            File storage = new File(this.karafData.getPath(), "cache");
            try {
                storage.mkdirs();
            }
            catch (SecurityException se) {
                throw new Exception(se.getMessage());
            }
            this.configProps.setProperty("org.osgi.framework.storage", storage.getAbsolutePath());
        }
        this.defaultStartLevel = Integer.parseInt(this.configProps.getProperty("org.osgi.framework.startlevel.beginning"));
        System.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.defaultStartLevel));
        this.lockStartLevel = Integer.parseInt(this.configProps.getProperty(PROPERTY_LOCK_LEVEL, Integer.toString(this.lockStartLevel)));
        this.lockDelay = Integer.parseInt(this.configProps.getProperty(PROPERTY_LOCK_DELAY, DEFAULT_LOCK_DELAY));
        this.configProps.setProperty("org.osgi.framework.startlevel.beginning", Integer.toString(this.lockStartLevel));
        this.shutdownTimeout = Integer.parseInt(this.configProps.getProperty(KARAF_SHUTDOWN_TIMEOUT, Integer.toString(this.shutdownTimeout)));
        String factoryClass = this.configProps.getProperty(KARAF_FRAMEWORK_FACTORY);
        if (factoryClass == null) {
            InputStream is = classLoader.getResourceAsStream("META-INF/services/" + FrameworkFactory.class.getName());
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            factoryClass = br.readLine();
            br.close();
        }
        FrameworkFactory factory = (FrameworkFactory)classLoader.loadClass(factoryClass).newInstance();
        this.framework = factory.newFramework(new StringMap(this.configProps, false));
        this.framework.init();
        this.loadStartupProperties(this.configProps);
        this.processAutoProperties(this.framework.getBundleContext());
        this.startLevelListener = new StartLevelListener(this.startLevelLock);
        this.framework.getBundleContext().addFrameworkListener(this.startLevelListener);
        this.framework.start();
        this.startKarafActivators(classLoader);
        if (delayConsoleStart) {
            new StartupListener(this.framework.getBundleContext());
        }
        new Thread(){

            public void run() {
                Main.this.lock(Main.this.configProps);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startKarafActivators(ClassLoader classLoader) throws IOException {
        Enumeration<URL> urls = classLoader.getResources("META-INF/MANIFEST.MF");
        while (urls != null && urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String className = null;
            InputStream is = url.openStream();
            try {
                Manifest mf = new Manifest(is);
                className = mf.getMainAttributes().getValue(KARAF_ACTIVATOR);
                if (className == null) continue;
                BundleActivator activator = (BundleActivator)classLoader.loadClass(className).newInstance();
                activator.start(this.framework.getBundleContext());
                this.karafActivators.add(activator);
            }
            catch (Throwable e) {
                if (className == null) continue;
                System.err.println("Error starting karaf activator " + className + ": " + e.getMessage());
                this.LOG.log(Level.WARNING, "Error starting karaf activator " + className + " from url " + url, e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void stopKarafActivators() {
        for (BundleActivator activator : this.karafActivators) {
            try {
                activator.stop(this.framework.getBundleContext());
            }
            catch (Throwable e) {
                this.LOG.log(Level.WARNING, "Error stopping karaf activator " + activator.getClass().getName(), e);
            }
        }
    }

    public void awaitShutdown() throws Exception {
        FrameworkEvent event;
        if (this.framework == null) {
            return;
        }
        while ((event = this.framework.waitForStop(0L)).getType() == 128) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroy() throws Exception {
        if (this.framework == null) {
            return true;
        }
        try {
            int step = 5000;
            if (this.shutdownCallback != null) {
                this.shutdownCallback.waitingForShutdown(step);
            }
            this.exiting = true;
            if (this.framework.getState() == 32 || this.framework.getState() == 8) {
                new Thread(){

                    public void run() {
                        try {
                            Main.this.framework.stop();
                        }
                        catch (BundleException e) {
                            System.err.println("Error stopping karaf: " + e.getMessage());
                        }
                    }
                }.start();
            }
            int timeout = this.shutdownTimeout;
            if (this.shutdownTimeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            while (timeout > 0) {
                FrameworkEvent event;
                timeout -= step;
                if (this.shutdownCallback != null) {
                    this.shutdownCallback.waitingForShutdown(step * 2);
                }
                if ((event = this.framework.waitForStop(step)).getType() == 512) continue;
                this.stopKarafActivators();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        while (true) {
            boolean restart = false;
            System.setProperty("karaf.restart", "false");
            if (Boolean.getBoolean("karaf.restart.clean")) {
                File karafHome = Utils.getKarafHome();
                File karafBase = Utils.getKarafDirectory(PROP_KARAF_BASE, ENV_KARAF_BASE, karafHome, false, true);
                File karafData = Utils.getKarafDirectory(PROP_KARAF_DATA, ENV_KARAF_DATA, new File(karafBase, "data"), true, true);
                Utils.deleteDirectory(karafData);
            }
            Main main = new Main(args);
            try {
                main.launch();
            }
            catch (Throwable ex) {
                main.destroy();
                main.setExitCode(-1);
                System.err.println("Could not create framework: " + ex);
                ex.printStackTrace();
            }
            try {
                main.awaitShutdown();
                boolean stopped = main.destroy();
                restart = Boolean.getBoolean("karaf.restart");
                if (stopped) continue;
                if (restart) {
                    System.err.println("Timeout waiting for framework to stop.  Restarting now.");
                    continue;
                }
                System.err.println("Timeout waiting for framework to stop.  Exiting VM.");
                main.setExitCode(-3);
                continue;
            }
            catch (Throwable ex) {
                main.setExitCode(-2);
                System.err.println("Error occurred shutting down framework: " + ex);
                ex.printStackTrace();
                continue;
            }
            finally {
                if (restart) continue;
                System.exit(main.getExitCode());
                continue;
            }
            break;
        }
    }

    private static void processSecurityProperties(java.util.Properties m_configProps) {
        String prop = m_configProps.getProperty(SECURITY_PROVIDERS);
        if (prop != null) {
            String[] providers;
            for (String provider : providers = prop.split(",")) {
                Main.addProvider(provider);
            }
        }
    }

    private static void addProvider(String provider) {
        try {
            Security.addProvider((Provider)Class.forName(provider).newInstance());
        }
        catch (Throwable t) {
            System.err.println("Unable to register security provider: " + t);
        }
    }

    private void updateInstancePid() {
        block7: {
            try {
                final String instanceName = System.getProperty("karaf.name");
                final String pid = Main.getPid();
                final boolean isRoot = this.karafHome.equals(this.karafBase);
                if (instanceName == null) break block7;
                String storage = System.getProperty(PROP_KARAF_INSTANCES);
                if (storage == null) {
                    throw new Exception("System property 'karaf.instances' is not set. \nThis property needs to be set to the full path of the instance.properties file.");
                }
                File storageFile = new File(storage);
                final File propertiesFile = new File(storageFile, "instance.properties");
                if (!propertiesFile.getParentFile().exists()) {
                    try {
                        if (!propertiesFile.getParentFile().mkdirs()) {
                            throw new Exception("Unable to create directory " + propertiesFile.getParentFile());
                        }
                    }
                    catch (SecurityException se) {
                        throw new Exception(se.getMessage());
                    }
                }
                FileLockUtils.execute(propertiesFile, new FileLockUtils.RunnableWithProperties(){

                    public void run(Properties props) throws IOException {
                        if (props.isEmpty()) {
                            if (!isRoot) {
                                throw new IllegalStateException("Child instance started but no root registered in " + propertiesFile);
                            }
                        } else {
                            int count = Integer.parseInt(props.getProperty("count"));
                            if (isRoot) {
                                for (int i = 0; i < count; ++i) {
                                    boolean root = Boolean.parseBoolean(props.getProperty("item." + i + ".root", "false"));
                                    if (!root) continue;
                                    props.setProperty("item." + i + ".name", instanceName);
                                    props.setProperty("item." + i + ".pid", pid);
                                    return;
                                }
                                throw new IllegalStateException("Unable to find root instance in " + propertiesFile);
                            }
                            for (int i = 0; i < count; ++i) {
                                String name = props.getProperty("item." + i + ".name");
                                if (!name.equals(instanceName)) continue;
                                props.setProperty("item." + i + ".pid", pid);
                                return;
                            }
                            throw new IllegalStateException("Unable to find instance '" + instanceName + "'in " + propertiesFile);
                        }
                        props.setProperty("count", "1");
                        props.setProperty("item.0.name", instanceName);
                        props.setProperty("item.0.loc", Main.this.karafHome.getAbsolutePath());
                        props.setProperty("item.0.pid", pid);
                        props.setProperty("item.0.root", "true");
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Unable to update instance pid: " + e.getMessage());
            }
        }
    }

    private static String getPid() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        if (pid.indexOf(64) > 0) {
            pid = pid.substring(0, pid.indexOf(64));
        }
        return pid;
    }

    private void processAutoProperties(BundleContext context) {
        boolean convertToMavenUrls = Boolean.parseBoolean(this.configProps.getProperty(PROPERTY_CONVERT_TO_MAVEN_URL, "true"));
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        int ibsl = 60;
        try {
            String str = this.configProps.getProperty("karaf.startlevel.bundle");
            if (str != null) {
                ibsl = Integer.parseInt(str);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        sl.setInitialBundleStartLevel(ibsl);
        if (this.framework.getBundleContext().getBundles().length == 1) {
            this.autoInstall(PROPERTY_AUTO_INSTALL, context, sl, convertToMavenUrls, false);
            this.autoInstall(PROPERTY_AUTO_START, context, sl, convertToMavenUrls, true);
        }
    }

    private List<Bundle> autoInstall(String propertyPrefix, BundleContext context, StartLevel sl, boolean convertToMavenUrls, boolean start) {
        TreeMap<Integer, String> autoStart = new TreeMap<Integer, String>();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Object o : this.configProps.keySet()) {
            String key = (String)o;
            if (!key.startsWith(propertyPrefix)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            if (!key.equals(propertyPrefix)) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + key);
                }
            }
            autoStart.put(startLevel, this.configProps.getProperty(key));
        }
        for (Integer startLevel : autoStart.keySet()) {
            String location;
            StringTokenizer st = new StringTokenizer((String)autoStart.get(startLevel), "\" ", true);
            if (st.countTokens() <= 0) continue;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                try {
                    String[] parts = Main.convertToMavenUrlsIfNeeded(location, convertToMavenUrls);
                    Bundle b = context.installBundle(parts[0], new URL(parts[1]).openStream());
                    sl.setBundleStartLevel(b, startLevel);
                    bundles.add(b);
                }
                catch (Exception ex) {
                    System.err.println("Error installing bundle  " + location + ": " + ex);
                }
            } while (location != null);
        }
        if (start) {
            for (Bundle b : bundles) {
                try {
                    String fragmentHostHeader = b.getHeaders().get("Fragment-Host");
                    if (fragmentHostHeader != null && fragmentHostHeader.trim().length() != 0) continue;
                    b.start();
                }
                catch (Exception ex) {
                    System.err.println("Error starting bundle " + b.getSymbolicName() + ": " + ex);
                }
            }
        }
        return bundles;
    }

    private static String[] convertToMavenUrlsIfNeeded(String location, boolean convertToMavenUrls) {
        String[] parts = location.split("\\|");
        if (convertToMavenUrls) {
            String[] p = parts[1].split("/");
            if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
                String artifactId = p[p.length - 3];
                String version = p[p.length - 2];
                String artifactIdVersion = artifactId + "-" + version;
                StringBuffer sb = new StringBuffer();
                String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
                String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
                sb.append("mvn:");
                for (int j = 0; j < p.length - 3; ++j) {
                    if (j > 0) {
                        sb.append('.');
                    }
                    sb.append(p[j]);
                }
                sb.append('/').append(artifactId).append('/').append(version);
                if (!"jar".equals(type) || classifier != null) {
                    sb.append('/');
                    if (!"jar".equals(type)) {
                        sb.append(type);
                    }
                    if (classifier != null) {
                        sb.append('/').append(classifier);
                    }
                }
                parts[1] = parts[0];
                parts[0] = sb.toString();
            } else {
                parts[1] = parts[0];
            }
        } else {
            parts[1] = parts[0];
        }
        return parts;
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                String tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    protected static void loadSystemProperties(File karafBase) {
        URL propURL;
        try {
            File file = new File(new File(karafBase, "etc"), SYSTEM_PROPERTIES_FILE_NAME);
            propURL = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        java.util.Properties props = new java.util.Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith(OVERRIDE_PREFIX)) {
                String overrideName = name.substring(OVERRIDE_PREFIX.length());
                String value = props.getProperty(name);
                System.setProperty(overrideName, Main.substVars(value, name, null, props));
                continue;
            }
            String value = System.getProperty(name, props.getProperty(name));
            System.setProperty(name, Main.substVars(value, name, null, props));
        }
    }

    private java.util.Properties loadConfigProperties() throws Exception {
        URL configPropURL;
        try {
            File etcFolder = new File(this.karafBase, "etc");
            if (!etcFolder.exists()) {
                throw new FileNotFoundException("etc folder not found: " + etcFolder.getAbsolutePath());
            }
            File file = new File(etcFolder, CONFIG_PROPERTIES_FILE_NAME);
            configPropURL = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        java.util.Properties configProps = Main.loadPropertiesFile(configPropURL, false);
        Enumeration<?> e = configProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            configProps.setProperty(name, Main.substVars(configProps.getProperty(name), name, null, configProps));
        }
        return configProps;
    }

    private void loadStartupProperties(java.util.Properties configProps) throws Exception {
        StringTokenizer st;
        ArrayList<File> bundleDirs = new ArrayList<File>();
        File etcFolder = new File(this.karafBase, "etc");
        if (!etcFolder.exists()) {
            throw new FileNotFoundException("etc folder not found: " + etcFolder.getAbsolutePath());
        }
        File file = new File(etcFolder, STARTUP_PROPERTIES_FILE_NAME);
        URL startupPropURL = file.toURI().toURL();
        java.util.Properties startupProps = Main.loadPropertiesFile(startupPropURL, true);
        String defaultRepo = System.getProperty(DEFAULT_REPO, "system");
        if (this.karafBase.equals(this.karafHome)) {
            File systemRepo = new File(this.karafHome, defaultRepo);
            if (!systemRepo.exists()) {
                throw new FileNotFoundException("system repo not found: " + systemRepo.getAbsolutePath());
            }
            bundleDirs.add(systemRepo);
        } else {
            File baseSystemRepo = new File(this.karafBase, defaultRepo);
            File homeSystemRepo = new File(this.karafHome, defaultRepo);
            if (!baseSystemRepo.exists() && !homeSystemRepo.exists()) {
                throw new FileNotFoundException("system repos not found: " + baseSystemRepo.getAbsolutePath() + " " + homeSystemRepo.getAbsolutePath());
            }
            bundleDirs.add(baseSystemRepo);
            bundleDirs.add(homeSystemRepo);
        }
        String locations = configProps.getProperty(BUNDLE_LOCATIONS);
        if (locations != null && (st = new StringTokenizer(locations, "\" ", true)).countTokens() > 0) {
            String location;
            do {
                if ((location = Main.nextLocation(st)) == null) continue;
                File f = this.karafBase.equals(this.karafHome) ? new File(this.karafHome, location) : new File(this.karafBase, location);
                if (f.exists() && f.isDirectory()) {
                    bundleDirs.add(f);
                    continue;
                }
                System.err.println("Bundle location " + location + " does not exist or is not a directory.");
            } while (location != null);
        }
        Main.processConfigurationProperties(configProps, startupProps, bundleDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static java.util.Properties loadPropertiesFile(URL configPropURL, boolean failIfNotFound) throws Exception {
        String optionals;
        java.util.Properties configProps = new java.util.Properties();
        InputStream is = null;
        try {
            is = configPropURL.openConnection().getInputStream();
            configProps.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
            if (failIfNotFound) {
                throw ex;
            }
            System.err.println("WARN: " + configPropURL + " is not found, so not loaded");
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            java.util.Properties properties = configProps;
            return properties;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {}
        }
        String includes = configProps.getProperty(INCLUDES_PROPERTY);
        if (includes != null) {
            StringTokenizer st = new StringTokenizer(includes, "\" ", true);
            if (st.countTokens() > 0) {
                String location;
                do {
                    if ((location = Main.nextLocation(st)) == null) continue;
                    URL url = new URL(configPropURL, location);
                    java.util.Properties props = Main.loadPropertiesFile(url, true);
                    configProps.putAll((Map<?, ?>)props);
                } while (location != null);
            }
            configProps.remove(INCLUDES_PROPERTY);
        }
        if ((optionals = configProps.getProperty(OPTIONALS_PROPERTY)) != null) {
            StringTokenizer st = new StringTokenizer(optionals, "\" ", true);
            if (st.countTokens() > 0) {
                String location;
                do {
                    if ((location = Main.nextLocation(st)) == null) continue;
                    URL url = new URL(configPropURL, location);
                    java.util.Properties props = Main.loadPropertiesFile(url, false);
                    configProps.putAll((Map<?, ?>)props);
                } while (location != null);
            }
            configProps.remove(OPTIONALS_PROPERTY);
        }
        Enumeration<?> e = configProps.propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!(key instanceof String)) continue;
            String v = configProps.getProperty((String)key);
            configProps.put(key.toString(), v.trim());
        }
        return configProps;
    }

    protected static void copySystemProperties(java.util.Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("karaf.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    private ClassLoader createClassLoader(java.util.Properties configProps) throws Exception {
        String framework = configProps.getProperty(KARAF_FRAMEWORK);
        if (framework == null) {
            throw new IllegalArgumentException("Property karaf.framework must be set in the etc/config.properties configuration file");
        }
        String bundle = configProps.getProperty("karaf.framework." + framework);
        if (bundle == null) {
            throw new IllegalArgumentException("Property karaf.framework." + framework + " must be set in the etc/" + CONFIG_PROPERTIES_FILE_NAME + " configuration file");
        }
        File bundleFile = new File(this.karafBase, bundle);
        if (!bundleFile.exists()) {
            bundleFile = new File(this.karafHome, bundle);
        }
        if (!bundleFile.exists()) {
            throw new FileNotFoundException(bundleFile.getAbsolutePath());
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(bundleFile.toURI().toURL());
        File[] libs = new File(this.karafHome, "lib").listFiles();
        if (libs != null) {
            for (File f : libs) {
                if (!f.isFile() || !f.canRead() || !f.getName().endsWith(".jar")) continue;
                urls.add(f.toURI().toURL());
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Main.class.getClassLoader());
    }

    private static void processConfigurationProperties(java.util.Properties configProps, java.util.Properties startupProps, List<File> bundleDirs) throws Exception {
        if (bundleDirs == null) {
            return;
        }
        boolean hasErrors = false;
        if ("all".equals(configProps.getProperty(PROPERTY_AUTO_START, "").trim())) {
            configProps.remove(PROPERTY_AUTO_START);
            ArrayList<File> jars = new ArrayList<File>();
            for (File file : bundleDirs) {
                Main.findJars(file, jars);
            }
            StringBuffer sb = new StringBuffer();
            for (File jar : jars) {
                try {
                    sb.append("\"").append(jar.toURI().toURL().toString()).append("\" ");
                }
                catch (MalformedURLException e) {
                    System.err.print("Ignoring " + jar.toString() + " (" + e + ")");
                }
            }
            configProps.setProperty(PROPERTY_AUTO_START, sb.toString());
        } else if (STARTUP_PROPERTIES_FILE_NAME.equals(configProps.getProperty(PROPERTY_AUTO_START, "").trim())) {
            configProps.remove(PROPERTY_AUTO_START);
            HashMap<Integer, StringBuffer> levels = new HashMap<Integer, StringBuffer>();
            for (Object object : startupProps.keySet()) {
                String name = (String)object;
                File file = Main.findFile(bundleDirs, name);
                if (file != null) {
                    Integer level;
                    try {
                        level = new Integer(startupProps.getProperty(name).trim());
                    }
                    catch (NumberFormatException e1) {
                        System.err.print("Ignoring " + file.toString() + " (run level must be an integer)");
                        continue;
                    }
                    StringBuffer sb = (StringBuffer)levels.get(level);
                    if (sb == null) {
                        sb = new StringBuffer(256);
                        levels.put(level, sb);
                    }
                    try {
                        sb.append("\"").append(file.toURI().toURL().toString()).append("|").append(name).append("\" ");
                    }
                    catch (MalformedURLException e) {
                        System.err.print("Ignoring " + file.toString() + " (" + e + ")");
                    }
                    continue;
                }
                System.err.println("Bundle listed in startup.properties configuration not found: " + name);
                hasErrors = true;
            }
            for (Map.Entry entry : levels.entrySet()) {
                configProps.setProperty("karaf.auto.start." + entry.getKey(), ((StringBuffer)entry.getValue()).toString());
            }
        }
        if (hasErrors) {
            throw new Exception("Aborting due to missing startup bundles");
        }
    }

    private static File findFile(List<File> bundleDirs, String name) {
        for (File bundleDir : bundleDirs) {
            File file = Main.findFile(bundleDir, name);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static File findFile(File dir, String name) {
        File theFile = new File(dir, name);
        if (theFile.exists() && !theFile.isDirectory()) {
            return theFile;
        }
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            return Main.findFile(file, name);
        }
        return null;
    }

    private static void findJars(File dir, ArrayList<File> jars) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Main.findJars(file, jars);
                continue;
            }
            if (!file.toString().endsWith(".jar")) continue;
            jars.add(file);
        }
    }

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, java.util.Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Main.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void lock(java.util.Properties props) {
        try {
            if (Boolean.parseBoolean(props.getProperty(PROPERTY_USE_LOCK, "true"))) {
                this.doLock(props);
            } else {
                this.setStartLevel(this.defaultStartLevel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLock(java.util.Properties props) throws Exception {
        String clz = props.getProperty(PROPERTY_LOCK_CLASS, PROPERTY_LOCK_CLASS_DEFAULT);
        this.lock = (Lock)Class.forName(clz).getConstructor(java.util.Properties.class).newInstance(props);
        boolean lockLogged = false;
        this.setStartLevel(this.lockStartLevel);
        while (!this.exiting) {
            if (this.lock.lock()) {
                if (lockLogged) {
                    this.LOG.info("Lock acquired.");
                }
                this.setupShutdown(props);
                this.setStartLevel(this.defaultStartLevel);
                while (this.lock.isAlive()) {
                    Thread.sleep(this.lockDelay);
                }
                if (this.framework.getState() == 32 && !this.exiting) {
                    this.LOG.info("Lost the lock, reducing start level to " + this.lockStartLevel);
                    Object object = this.startLevelLock;
                    synchronized (object) {
                        this.setStartLevel(this.lockStartLevel);
                        this.LOG.fine("Waiting for start level change to complete...");
                        this.startLevelLock.wait(this.shutdownTimeout);
                    }
                }
            } else if (!lockLogged) {
                this.LOG.info("Waiting for the lock ...");
                lockLogged = true;
            }
            Thread.sleep(this.lockDelay);
        }
    }

    public void unlock() throws Exception {
        if (this.lock != null) {
            this.lock.release();
        }
    }

    protected void setStartLevel(int level) throws Exception {
        BundleContext ctx = this.framework.getBundleContext();
        ServiceReference<?>[] refs = ctx.getServiceReferences(StartLevel.class.getName(), null);
        StartLevel sl = (StartLevel)ctx.getService(refs[0]);
        sl.setStartLevel(level);
    }

    protected void setupShutdown(java.util.Properties props) {
        this.writePid(props);
        try {
            int port = Integer.parseInt(props.getProperty(KARAF_SHUTDOWN_PORT, "0"));
            String host = props.getProperty(KARAF_SHUTDOWN_HOST, "localhost");
            String portFile = props.getProperty(KARAF_SHUTDOWN_PORT_FILE);
            String shutdown = props.getProperty(KARAF_SHUTDOWN_COMMAND, DEFAULT_SHUTDOWN_COMMAND);
            if (port >= 0) {
                this.shutdownSocket = new ServerSocket(port, 1, InetAddress.getByName(host));
                if (port == 0) {
                    port = this.shutdownSocket.getLocalPort();
                }
                if (portFile != null) {
                    OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(portFile));
                    w.write(Integer.toString(port));
                    ((Writer)w).close();
                }
                ShutdownSocketThread thread = new ShutdownSocketThread(shutdown);
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePid(java.util.Properties props) {
        try {
            String pidFile = props.getProperty(KARAF_SHUTDOWN_PID_FILE);
            if (pidFile != null) {
                RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
                String processName = rtb.getName();
                Pattern pattern = Pattern.compile("^([0-9]+)@.+$", 2);
                Matcher matcher = pattern.matcher(processName);
                if (matcher.matches()) {
                    int pid = Integer.parseInt(matcher.group(1));
                    OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(pidFile));
                    w.write(Integer.toString(pid));
                    ((Writer)w).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    private class ShutdownSocketThread
    extends Thread {
        private final String shutdown;

        public ShutdownSocketThread(String shutdown) {
            this.shutdown = shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    int expected;
                    Socket socket = null;
                    InputStream stream = null;
                    try {
                        socket = Main.this.shutdownSocket.accept();
                        socket.setSoTimeout(10000);
                        stream = socket.getInputStream();
                    }
                    catch (AccessControlException ace) {
                        Main.this.LOG.log(Level.WARNING, "Karaf shutdown socket: security exception: " + ace.getMessage(), ace);
                        continue;
                    }
                    catch (IOException e) {
                        Main.this.LOG.log(Level.SEVERE, "Karaf shutdown socket: accept: ", e);
                        System.exit(1);
                    }
                    StringBuilder command = new StringBuilder();
                    for (expected = 1024; expected < this.shutdown.length(); expected += Main.this.random.nextInt() % 1024) {
                        if (Main.this.random != null) continue;
                        Main.this.random = new Random();
                    }
                    while (expected > 0) {
                        int ch;
                        try {
                            ch = stream.read();
                        }
                        catch (IOException e) {
                            Main.this.LOG.log(Level.WARNING, "Karaf shutdown socket:  read: ", e);
                            ch = -1;
                        }
                        if (ch < 32) break;
                        command.append((char)ch);
                        --expected;
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    boolean match = command.toString().equals(this.shutdown);
                    if (match) {
                        Main.this.LOG.log(Level.INFO, "Karaf shutdown socket: received shutdown command. Stopping framework...");
                        Main.this.framework.stop();
                        break;
                    }
                    Main.this.LOG.log(Level.WARNING, "Karaf shutdown socket:  Invalid command '" + command.toString() + "' received");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    Main.this.shutdownSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

