/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.obr.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Resolver;
import org.apache.karaf.features.obr.internal.BundleInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObrResolver
implements Resolver {
    private RepositoryAdmin repositoryAdmin;
    private boolean resolveOptionalImports;

    public RepositoryAdmin getRepositoryAdmin() {
        return this.repositoryAdmin;
    }

    public void setRepositoryAdmin(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public boolean isResolveOptionalImports() {
        return this.resolveOptionalImports;
    }

    public void setResolveOptionalImports(boolean resolveOptionalImports) {
        this.resolveOptionalImports = resolveOptionalImports;
    }

    public List<BundleInfo> resolve(Feature feature) throws Exception {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        ArrayList<Resource> ress = new ArrayList<Resource>();
        ArrayList deploy = new ArrayList();
        HashMap<Object, BundleInfo> infos = new HashMap<Object, BundleInfo>();
        for (BundleInfo bundleInfo : feature.getBundles()) {
            URL url = null;
            try {
                url = new URL(bundleInfo.getLocation());
            }
            catch (MalformedURLException e) {
                Requirement req = this.parseRequirement(bundleInfo.getLocation());
                reqs.add(req);
                infos.put(req, bundleInfo);
            }
            if (url == null) continue;
            Resource res = this.repositoryAdmin.getHelper().createResource(url);
            ress.add(res);
            infos.put(res, bundleInfo);
        }
        Repository repository = this.repositoryAdmin.getHelper().repository(ress.toArray(new Resource[ress.size()]));
        ArrayList<Repository> repos = new ArrayList<Repository>();
        repos.add(this.repositoryAdmin.getSystemRepository());
        repos.add(this.repositoryAdmin.getLocalRepository());
        repos.add(repository);
        repos.addAll(Arrays.asList(this.repositoryAdmin.listRepositories()));
        org.apache.felix.bundlerepository.Resolver resolver = this.repositoryAdmin.resolver(repos.toArray(new Repository[repos.size()]));
        for (Resource res : ress) {
            if (((BundleInfo)infos.get(res)).isDependency()) continue;
            resolver.add(res);
        }
        for (Requirement req : reqs) {
            resolver.add(req);
        }
        if (!this.doResolve(resolver)) {
            StringWriter w = new StringWriter();
            PrintWriter out = new PrintWriter(w);
            Reason[] failedReqs = resolver.getUnsatisfiedRequirements();
            if (failedReqs != null && failedReqs.length > 0) {
                out.println("Unsatisfied requirement(s):");
                this.printUnderline(out, 27);
                for (Reason r : failedReqs) {
                    out.println("   " + r.getRequirement().getName() + ":" + r.getRequirement().getFilter());
                    out.println("      " + r.getResource().getPresentationName());
                }
            } else {
                out.println("Could not resolve targets.");
            }
            out.flush();
            throw new Exception("Can not resolve feature:\n" + w.toString());
        }
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        Collections.addAll(deploy, resolver.getAddedResources());
        Collections.addAll(deploy, resolver.getRequiredResources());
        if (this.resolveOptionalImports) {
            Collections.addAll(deploy, resolver.getOptionalResources());
        }
        for (Resource res : deploy) {
            Reason[] reasons;
            BundleInfo info = (BundleInfo)infos.get(res);
            if (info == null && (reasons = resolver.getReason(res)) != null) {
                Reason r;
                Reason[] arr$ = reasons;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (info = (BundleInfo)infos.get(r = arr$[i$])) == null; ++i$) {
                }
            }
            if (info == null) {
                info = new BundleInfoImpl(res.getURI());
            }
            bundles.add(info);
        }
        return bundles;
    }

    private boolean doResolve(org.apache.felix.bundlerepository.Resolver resolver) {
        if (this.resolveOptionalImports) {
            return resolver.resolve();
        }
        return resolver.resolve(1);
    }

    protected void printUnderline(PrintWriter out, int length) {
        for (int i = 0; i < length; ++i) {
            out.print('-');
        }
        out.println("");
    }

    protected Requirement parseRequirement(String req) {
        String filter;
        String name;
        int p = req.indexOf(58);
        if (p > 0) {
            name = req.substring(0, p);
            filter = req.substring(p + 1);
        } else {
            name = req.contains("package") ? "package" : (req.contains("service") ? "service" : "bundle");
            filter = req;
        }
        if (!filter.startsWith("(")) {
            filter = "(" + filter + ")";
        }
        return this.repositoryAdmin.getHelper().requirement(name, filter);
    }
}

