/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.management.DefaultManagementNamingStrategy;
import org.apache.camel.management.DefaultManagementObjectStrategy;
import org.apache.camel.management.event.DefaultEventFactory;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class DefaultManagementStrategy
implements ManagementStrategy,
CamelContextAware {
    private List<EventNotifier> eventNotifiers = new CopyOnWriteArrayList<EventNotifier>();
    private EventFactory eventFactory = new DefaultEventFactory();
    private ManagementNamingStrategy managementNamingStrategy;
    private ManagementObjectStrategy managementObjectStrategy;
    private boolean onlyManageProcessorWithCustomId;
    private ManagementAgent managementAgent;
    private ManagementStatisticsLevel statisticsLevel = ManagementStatisticsLevel.All;
    private boolean loadStatisticsEnabled = true;
    private CamelContext camelContext;

    public DefaultManagementStrategy() {
    }

    public DefaultManagementStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public List<EventNotifier> getEventNotifiers() {
        return this.eventNotifiers;
    }

    @Override
    public void addEventNotifier(EventNotifier eventNotifier) {
        this.eventNotifiers.add(eventNotifier);
    }

    @Override
    public boolean removeEventNotifier(EventNotifier eventNotifier) {
        return this.eventNotifiers.remove(eventNotifier);
    }

    @Override
    public void setEventNotifiers(List<EventNotifier> eventNotifiers) {
        this.eventNotifiers = eventNotifiers;
    }

    @Override
    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    @Override
    public void setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    @Override
    public ManagementNamingStrategy getManagementNamingStrategy() {
        if (this.managementNamingStrategy == null) {
            this.managementNamingStrategy = new DefaultManagementNamingStrategy();
        }
        return this.managementNamingStrategy;
    }

    @Override
    public void setManagementNamingStrategy(ManagementNamingStrategy managementNamingStrategy) {
        this.managementNamingStrategy = managementNamingStrategy;
    }

    @Override
    public ManagementObjectStrategy getManagementObjectStrategy() {
        if (this.managementObjectStrategy == null) {
            this.managementObjectStrategy = new DefaultManagementObjectStrategy();
        }
        return this.managementObjectStrategy;
    }

    @Override
    public void setManagementObjectStrategy(ManagementObjectStrategy managementObjectStrategy) {
        this.managementObjectStrategy = managementObjectStrategy;
    }

    @Override
    public ManagementAgent getManagementAgent() {
        return this.managementAgent;
    }

    @Override
    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    @Override
    public void onlyManageProcessorWithCustomId(boolean flag) {
        this.onlyManageProcessorWithCustomId = flag;
    }

    @Override
    public boolean isOnlyManageProcessorWithCustomId() {
        return this.onlyManageProcessorWithCustomId;
    }

    @Override
    public boolean manageProcessor(ProcessorDefinition<?> definition) {
        return false;
    }

    @Override
    public void manageObject(Object managedObject) throws Exception {
    }

    @Override
    public void manageNamedObject(Object managedObject, Object preferredName) throws Exception {
    }

    @Override
    public <T> T getManagedObjectName(Object managedObject, String customName, Class<T> nameType) throws Exception {
        return null;
    }

    @Override
    public void unmanageObject(Object managedObject) throws Exception {
    }

    @Override
    public void unmanageNamedObject(Object name) throws Exception {
    }

    @Override
    public boolean isManaged(Object managedObject, Object name) {
        return false;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void notify(EventObject event) throws Exception {
        if (this.eventNotifiers != null && !this.eventNotifiers.isEmpty()) {
            for (EventNotifier notifier : this.eventNotifiers) {
                if (!notifier.isEnabled(event)) continue;
                notifier.notify(event);
            }
        }
    }

    public Statistic createStatistic(String name, Object owner, Statistic.UpdateMode updateMode) {
        return null;
    }

    @Override
    public void setStatisticsLevel(ManagementStatisticsLevel level) {
        this.statisticsLevel = level;
    }

    @Override
    public ManagementStatisticsLevel getStatisticsLevel() {
        return this.statisticsLevel;
    }

    @Override
    public boolean isLoadStatisticsEnabled() {
        return this.loadStatisticsEnabled;
    }

    @Override
    public void setLoadStatisticsEnabled(boolean loadStatisticsEnabled) {
        this.loadStatisticsEnabled = loadStatisticsEnabled;
    }

    @Override
    public void start() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        if (this.eventNotifiers != null) {
            for (EventNotifier notifier : this.eventNotifiers) {
                if (notifier instanceof CamelContextAware) {
                    CamelContextAware aware = (CamelContextAware)((Object)notifier);
                    aware.setCamelContext(this.camelContext);
                }
                ServiceHelper.startService(notifier);
            }
        }
        if (this.managementAgent != null) {
            this.managementAgent.start();
            if (this.managementNamingStrategy == null) {
                this.setManagementNamingStrategy(new DefaultManagementNamingStrategy(this.managementAgent.getMBeanObjectDomainName()));
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.managementAgent != null) {
            this.managementAgent.stop();
        }
        if (this.eventNotifiers != null) {
            ServiceHelper.stopServices(this.eventNotifiers);
        }
    }
}

