/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    public static final int BUFFER_SIZE = 131072;
    private static final transient Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;
    private static String gUserDir;
    private static URI gUserDirURI;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    private FileUtil() {
    }

    public static synchronized URI getUserDir() throws URISyntaxException {
        int i;
        int ch;
        String userDir = "";
        try {
            userDir = System.getProperty("user.dir");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (userDir.length() == 0) {
            return new URI("file", "", "", null, null);
        }
        if (gUserDirURI != null && userDir.equals(gUserDir)) {
            return gUserDirURI;
        }
        gUserDir = userDir;
        char separator = File.separatorChar;
        userDir = userDir.replace(separator, '/');
        int len = userDir.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        if (len >= 2 && userDir.charAt(1) == ':' && (ch = Character.toUpperCase(userDir.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; i < len && (ch = userDir.charAt(i)) < 128; ++i) {
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = userDir.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new URI("file", "", userDir, null, null);
            }
            for (byte b : bytes) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        if (!userDir.endsWith("/")) {
            buffer.append('/');
        }
        gUserDirURI = new URI("file", "", buffer.toString(), null, null);
        return gUserDirURI;
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if (FileUtil.isWindows()) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File parent;
        File file = parent = parentDir == null ? FileUtil.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "camel";
        } else if (prefix.length() < 3) {
            prefix = prefix + "camel";
        }
        parent.mkdirs();
        return File.createTempFile(prefix, suffix, parent);
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static boolean hasLeadingSeparator(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith("/") || name.startsWith(File.separator);
    }

    public static String stripFirstLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripTrailingSeparator(String name) {
        if (ObjectHelper.isEmpty(name)) {
            return name;
        }
        String s = name;
        while (s.endsWith("/") || s.endsWith(File.separator)) {
            s = s.substring(0, s.length() - 1);
        }
        if (ObjectHelper.isEmpty(s)) {
            return name;
        }
        return s;
    }

    public static String stripPath(String name) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String stripExt(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String onlyPath(String name) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos > 0) {
            return name.substring(0, pos);
        }
        if (pos == 0) {
            return name.substring(0, 1);
        }
        return null;
    }

    public static String compactPath(String path) {
        return FileUtil.compactPath(path, File.separatorChar);
    }

    public static String compactPath(String path, char separator) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.indexOf(47) == -1 && path.indexOf(92) == -1) {
            return path;
        }
        boolean endsWithSlash = (path = FileUtil.normalizePath(path)).endsWith("/") || path.endsWith("\\");
        boolean startsWithSlash = path.startsWith("/") || path.startsWith("\\");
        Stack<String> stack = new Stack<String>();
        String separatorRegex = "\\\\|/";
        for (String part : parts = path.split(separatorRegex)) {
            if (part.equals("..") && !stack.isEmpty() && !"..".equals(stack.peek())) {
                stack.pop();
                continue;
            }
            if (part.equals(".") || part.isEmpty()) continue;
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        if (startsWithSlash) {
            sb.append(separator);
        }
        Iterator it = stack.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        if (endsWithSlash && stack.size() > 0) {
            sb.append(separator);
        }
        return sb.toString();
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = System.getProperty("java.io.tmpdir");
        File checkExists = new File(s);
        if (!checkExists.exists()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
        }
        Random ran = new Random();
        int x = ran.nextInt(1000000);
        File f = new File(s, "camel-tmp-" + x);
        while (!f.mkdir()) {
            x = ran.nextInt(1000000);
            f = new File(s, "camel-tmp-" + x);
        }
        defaultTempDir = f;
        Thread hook = new Thread(){

            @Override
            public void run() {
                FileUtil.removeDir(defaultTempDir);
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        return defaultTempDir;
    }

    private static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String s : list) {
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtil.removeDir(f);
                continue;
            }
            FileUtil.delete(f);
        }
        FileUtil.delete(d);
    }

    private static void delete(File f) {
        if (!f.delete()) {
            if (FileUtil.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    public static boolean renameFile(File from, File to, boolean copyAndDeleteOnRenameFail) throws IOException {
        int count;
        if (!from.exists()) {
            return false;
        }
        boolean renamed = false;
        for (count = 0; !renamed && count < 3; ++count) {
            if (LOG.isDebugEnabled() && count > 0) {
                LOG.debug("Retrying attempt {} to rename file from: {} to: {}", new Object[]{count, from, to});
            }
            if ((renamed = from.renameTo(to)) || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!renamed && copyAndDeleteOnRenameFail) {
            LOG.debug("Cannot rename file from: {} to: {}, will now use a copy/delete approach instead", (Object)from, (Object)to);
            FileUtil.copyFile(from, to);
            if (!FileUtil.deleteFile(from)) {
                throw new IOException("Renaming file from: " + from + " to: " + to + " failed due cannot delete from file: " + from + " after copy succeeded");
            }
            renamed = true;
        }
        if (LOG.isDebugEnabled() && count > 0) {
            LOG.debug("Tried {} to rename file: {} to: {} with result: {}", new Object[]{count, from, to, renamed});
        }
        return renamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = new FileInputStream(from).getChannel();
        FileChannel out = new FileOutputStream(to).getChannel();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using FileChannel to copy from: " + in + " to: " + out);
            }
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, 131072L, out)) {
            }
        }
        finally {
            IOHelper.close((Closeable)in, from.getName(), LOG);
            IOHelper.close((Closeable)out, to.getName(), LOG);
        }
    }

    public static boolean deleteFile(File file) {
        int count;
        if (!file.exists()) {
            return false;
        }
        boolean deleted = false;
        for (count = 0; !deleted && count < 3; ++count) {
            LOG.debug("Retrying attempt {} to delete file: {}", (Object)count, (Object)file);
            deleted = file.delete();
            if (deleted || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled() && count > 0) {
            LOG.debug("Tried {} to delete file: {} with result: {}", new Object[]{count, file, deleted});
        }
        return deleted;
    }

    public static boolean isAbsolute(File file) {
        String path;
        if (FileUtil.isWindows() && (path = file.getPath()).startsWith(File.separator)) {
            return true;
        }
        return file.isAbsolute();
    }

    public static boolean createNewFile(File file) throws IOException {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            if (file.exists()) {
                return true;
            }
            throw e;
        }
    }

    static {
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            FileUtil.gNeedEscaping[i] = true;
            FileUtil.gAfterEscaping1[i] = gHexChs[i >> 4];
            FileUtil.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        FileUtil.gNeedEscaping[127] = true;
        FileUtil.gAfterEscaping1[127] = 55;
        FileUtil.gAfterEscaping2[127] = 70;
        for (char ch : new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            FileUtil.gNeedEscaping[ch] = true;
            FileUtil.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            FileUtil.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

