/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.utils.HostUtils;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.fabric.zookeeper.ZkDefs;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafContainerRegistration
implements LifecycleListener,
NotificationListener,
ConfigurationListener {
    private transient Logger logger = LoggerFactory.getLogger(KarafContainerRegistration.class);
    public static final String IP_REGEX = "([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}";
    public static final String HOST_REGEX = "[a-zA-Z][a-zA-Z0-9\\-\\._]*[a-zA-Z]";
    public static final String IP_OR_HOST_REGEX = "((([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3})|([a-zA-Z][a-zA-Z0-9\\-\\._]*[a-zA-Z])|0.0.0.0)";
    public static final String RMI_HOST_REGEX = "://((([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3})|([a-zA-Z][a-zA-Z0-9\\-\\._]*[a-zA-Z])|0.0.0.0)";
    private static final String MANAGEMENT_PID = "org.apache.karaf.management";
    private static final String SHELL_PID = "org.apache.karaf.shell";
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private BundleContext bundleContext;
    private final Set<String> domains = new CopyOnWriteArraySet<String>();
    private volatile MBeanServer mbeanServer;

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public synchronized void onConnected() {
        String name = System.getProperty("karaf.name");
        this.logger.trace("onConnected");
        String nodeAlive = ZkPath.CONTAINER_ALIVE.getPath(name);
        try {
            String sshUrl;
            String jmxUrl;
            String domainsNode;
            Stat stat = ZooKeeperUtils.exists(this.zooKeeper, nodeAlive);
            if (stat != null) {
                if (stat.getEphemeralOwner() != this.zooKeeper.getSessionId()) {
                    this.zooKeeper.delete(nodeAlive);
                    this.zooKeeper.createWithParents(nodeAlive, CreateMode.EPHEMERAL);
                }
            } else {
                this.zooKeeper.createWithParents(nodeAlive, CreateMode.EPHEMERAL);
            }
            if ((stat = ZooKeeperUtils.exists(this.zooKeeper, domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(name))) != null) {
                this.zooKeeper.deleteWithChildren(domainsNode);
            }
            if ((jmxUrl = this.getJmxUrl()) != null) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_JMX.getPath(name), this.getJmxUrl());
            }
            if ((sshUrl = this.getSshUrl()) != null) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_SSH.getPath(name), this.getSshUrl());
            }
            if (ZooKeeperUtils.exists(this.zooKeeper, ZkPath.CONTAINER_RESOLVER.getPath(name)) == null) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_RESOLVER.getPath(name), KarafContainerRegistration.getContainerResolutionPolicy(this.zooKeeper, name));
            }
            ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(name), HostUtils.getLocalHostName());
            ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_LOCAL_IP.getPath(name), HostUtils.getLocalIp());
            ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_IP.getPath(name), KarafContainerRegistration.getContainerPointer(this.zooKeeper, name));
            if (ZooKeeperUtils.exists(this.zooKeeper, ZkPath.CONTAINER_GEOLOCATION.getPath(name)) == null) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_GEOLOCATION.getPath(name), HostUtils.getGeoLocation());
            }
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                String address = System.getProperty(resolver);
                if (address == null || address.isEmpty() || ZooKeeperUtils.exists(this.zooKeeper, ZkPath.CONTAINER_ADDRESS.getPath(name, resolver)) != null) continue;
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_ADDRESS.getPath(name, resolver), address);
            }
            String minimumPort = System.getProperty("minimum.port");
            String maximumPort = System.getProperty("maximum.port");
            if (ZooKeeperUtils.exists(this.zooKeeper, ZkPath.CONTAINER_PORT_MIN.getPath(name)) == null) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_PORT_MIN.getPath(name), minimumPort);
            }
            if (ZooKeeperUtils.exists(this.zooKeeper, ZkPath.CONTAINER_PORT_MAX.getPath(name)) == null) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_PORT_MAX.getPath(name), maximumPort);
            }
            String version = System.getProperty("fabric.version", "1.0");
            String profiles = System.getProperty("fabric.profiles");
            if (profiles != null) {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(name);
                String profileNode = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(version, name);
                if (ZooKeeperUtils.exists(this.zooKeeper, versionNode) == null) {
                    ZooKeeperUtils.set(this.zooKeeper, versionNode, version);
                }
                if (ZooKeeperUtils.exists(this.zooKeeper, profileNode) == null) {
                    ZooKeeperUtils.set(this.zooKeeper, profileNode, profiles);
                }
            }
            this.registerDomains();
        }
        catch (Exception e) {
            this.logger.warn("Error updating Fabric Container information. This exception will be ignored.", (Throwable)e);
        }
    }

    private String getJmxUrl() throws IOException {
        String name = System.getProperty("karaf.name");
        Configuration config = this.configurationAdmin.getConfiguration(MANAGEMENT_PID);
        if (config.getProperties() != null) {
            String jmx = (String)config.getProperties().get("serviceUrl");
            jmx = KarafContainerRegistration.replaceJmxHost(jmx, "\\${zk:" + name + "/ip}");
            return jmx;
        }
        return null;
    }

    private String getSshUrl() throws IOException {
        String name = System.getProperty("karaf.name");
        Configuration config = this.configurationAdmin.getConfiguration(SHELL_PID);
        if (config != null && config.getProperties() != null) {
            String port = (String)config.getProperties().get("sshPort");
            return "${zk:" + name + "/ip}:" + port;
        }
        return null;
    }

    private static String getGlobalResolutionPolicy(IZKClient zooKeeper) throws InterruptedException, KeeperException {
        String policy = "localhostname";
        List<String> validResoverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists(zooKeeper, ZkPath.POLICIES.getPath("resolver")) != null) {
            policy = ZooKeeperUtils.get(zooKeeper, ZkPath.POLICIES.getPath("resolver"));
        } else if (System.getProperty("global.resolver") != null && validResoverList.contains(System.getProperty("global.resolver"))) {
            policy = System.getProperty("global.resolver");
            ZooKeeperUtils.set(zooKeeper, ZkPath.POLICIES.getPath("resolver"), policy);
        }
        return policy;
    }

    private static String getContainerResolutionPolicy(IZKClient zooKeeper, String container) throws InterruptedException, KeeperException {
        String policy = null;
        List<String> validResoverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists(zooKeeper, ZkPath.CONTAINER_RESOLVER.getPath(container)) != null) {
            policy = ZooKeeperUtils.get(zooKeeper, ZkPath.CONTAINER_RESOLVER.getPath(container));
        } else if (System.getProperty("local.resolver") != null && validResoverList.contains(System.getProperty("local.resolver"))) {
            policy = System.getProperty("local.resolver");
        }
        if (policy == null) {
            policy = KarafContainerRegistration.getGlobalResolutionPolicy(zooKeeper);
        }
        if (policy != null && ZooKeeperUtils.exists(zooKeeper, ZkPath.CONTAINER_RESOLVER.getPath(container)) == null) {
            ZooKeeperUtils.set(zooKeeper, ZkPath.CONTAINER_RESOLVER.getPath(container), policy);
        }
        return policy;
    }

    private static String getContainerPointer(IZKClient zookeeper, String container) throws InterruptedException, KeeperException {
        String pointer = "${zk:%s/%s}";
        String policy = KarafContainerRegistration.getContainerResolutionPolicy(zookeeper, container);
        return String.format(pointer, container, policy);
    }

    public void destroy() {
        this.logger.trace("destroy");
        try {
            this.unregisterDomains();
        }
        catch (ServiceException e) {
            this.logger.trace("ZooKeeper is no longer available", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("An error occurred during disconnecting to zookeeper. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onDisconnected() {
        this.logger.trace("onDisconnected");
    }

    public synchronized void registerMBeanServer(ServiceReference ref) {
        try {
            String name = System.getProperty("karaf.name");
            this.mbeanServer = (MBeanServer)this.bundleContext.getService(ref);
            if (this.mbeanServer != null) {
                this.mbeanServer.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, (Object)name);
                this.registerDomains();
            }
        }
        catch (Exception e) {
            this.logger.warn("An error occurred during mbean server registration. This exception will be ignored.", (Throwable)e);
        }
    }

    public synchronized void unregisterMBeanServer(ServiceReference ref) {
        if (this.mbeanServer != null) {
            try {
                this.mbeanServer.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
                this.unregisterDomains();
            }
            catch (Exception e) {
                this.logger.warn("An error occurred during mbean server unregistration. This exception will be ignored.", (Throwable)e);
            }
        }
        this.mbeanServer = null;
        this.bundleContext.ungetService(ref);
    }

    protected void registerDomains() throws InterruptedException, KeeperException {
        if (this.isConnected() && this.mbeanServer != null) {
            String name = System.getProperty("karaf.name");
            this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
            for (String domain : this.mbeanServer.getDomains()) {
                ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_DOMAIN.getPath(name, domain), (byte[])null);
            }
        }
    }

    protected void unregisterDomains() throws InterruptedException, KeeperException {
        if (this.isConnected()) {
            String name = System.getProperty("karaf.name");
            String domainsPath = ZkPath.CONTAINER_DOMAINS.getPath(name);
            if (ZooKeeperUtils.exists(this.zooKeeper, domainsPath) != null) {
                for (String child : this.zooKeeper.getChildren(domainsPath)) {
                    this.zooKeeper.delete(domainsPath + "/" + child);
                }
            }
        }
    }

    @Override
    public synchronized void handleNotification(Notification notif, Object o) {
        this.logger.trace("handleNotification[{}]", (Object)notif);
        if (this.isConnected() && this.mbeanServer != null && notif instanceof MBeanServerNotification) {
            MBeanServerNotification notification = (MBeanServerNotification)notif;
            String domain = notification.getMBeanName().getDomain();
            String path = ZkPath.CONTAINER_DOMAIN.getPath((String)o, domain);
            try {
                if ("JMX.mbean.registered".equals(notification.getType())) {
                    if (this.domains.add(domain) && ZooKeeperUtils.exists(this.zooKeeper, path) == null) {
                        ZooKeeperUtils.set(this.zooKeeper, path, "");
                    }
                } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
                    this.domains.clear();
                    this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
                    if (!this.domains.contains(domain)) {
                        try {
                            this.zooKeeper.delete(path);
                        }
                        catch (KeeperException.NoNodeException e) {}
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Exception while jmx domain synchronization from event: " + notif + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public static String replaceJmxHost(String jmxUrl, String hostName) {
        if (jmxUrl == null) {
            return null;
        }
        return jmxUrl.replaceAll(RMI_HOST_REGEX, "://" + hostName);
    }

    private boolean isConnected() {
        return this.zooKeeper != null && this.zooKeeper.isConnected();
    }

    public void configurationEvent(ConfigurationEvent event) {
        try {
            if (this.zooKeeper.isConnected()) {
                String jmxUrl;
                String sshUrl;
                String name = System.getProperty("karaf.name");
                if (event.getPid().equals(SHELL_PID) && event.getType() == 1 && (sshUrl = this.getSshUrl()) != null) {
                    ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_SSH.getPath(name), this.getSshUrl());
                }
                if (event.getPid().equals(MANAGEMENT_PID) && event.getType() == 1 && (jmxUrl = this.getJmxUrl()) != null) {
                    ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONTAINER_JMX.getPath(name), this.getJmxUrl());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

