/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v4;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v4.BaseDataStreamMarshaller;

public class MessageIdMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 110;
    }

    @Override
    public DataStructure createObject() {
        return new MessageId();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessageId info2 = (MessageId)o;
        info2.setProducerId((ProducerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setProducerSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setBrokerSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageId info2 = (MessageId)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getProducerId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getProducerSequenceId(), bs);
        return (rc += this.tightMarshalLong1(wireFormat, info2.getBrokerSequenceId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessageId info2 = (MessageId)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getProducerId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getProducerSequenceId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getBrokerSequenceId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessageId info2 = (MessageId)o;
        info2.setProducerId((ProducerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setProducerSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setBrokerSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessageId info2 = (MessageId)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getProducerId(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getProducerSequenceId(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getBrokerSequenceId(), dataOut);
    }
}

