/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpTransport;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.tcp.SslTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransportFilter
extends TransportFilter
implements AmqpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransportFilter.class);
    private static final Logger TRACE = LoggerFactory.getLogger((String)(AmqpTransportFilter.class.getPackage().getName() + ".AMQPIO"));
    private final AmqpProtocolConverter protocolConverter;
    private AmqpWireFormat wireFormat;
    private boolean trace;
    private String transformer = "native";

    public AmqpTransportFilter(Transport next, WireFormat wireFormat, BrokerContext brokerContext) {
        super(next);
        this.protocolConverter = new AmqpProtocolConverter(this, brokerContext);
        if (wireFormat instanceof AmqpWireFormat) {
            this.wireFormat = (AmqpWireFormat)wireFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void oneway(Object o) throws IOException {
        try {
            Command command = (Command)o;
            this.protocolConverter.lock.lock();
            try {
                this.protocolConverter.onActiveMQCommand(command);
            }
            finally {
                this.protocolConverter.lock.unlock();
            }
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(IOException error2) {
        this.protocolConverter.lock.lock();
        try {
            this.protocolConverter.onAMQPException(error2);
        }
        finally {
            this.protocolConverter.lock.unlock();
        }
    }

    @Override
    public void sendToActiveMQ(IOException error2) {
        super.onException(error2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommand(Object command) {
        try {
            if (this.trace) {
                TRACE.trace("Received: \n" + command);
            }
            this.protocolConverter.lock.lock();
            try {
                this.protocolConverter.onAMQPData(command);
            }
            finally {
                this.protocolConverter.lock.unlock();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    public void sendToActiveMQ(Command command) {
        assert (this.protocolConverter.lock.isHeldByCurrentThread());
        TransportListener l = this.transportListener;
        if (l != null) {
            l.onCommand(command);
        }
    }

    @Override
    public void sendToAmqp(Object command) throws IOException {
        Transport n;
        assert (this.protocolConverter.lock.isHeldByCurrentThread());
        if (this.trace) {
            TRACE.trace("Sending: \n" + command);
        }
        if ((n = this.next) != null) {
            n.oneway(command);
        }
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        if (this.next instanceof SslTransport) {
            X509Certificate[] peerCerts = ((SslTransport)this.next).getPeerCertificates();
            if (this.trace && peerCerts != null) {
                LOG.debug("Peer Identity has been verified\n");
            }
            return peerCerts;
        }
        return null;
    }

    @Override
    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public AmqpWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void handleException(IOException e) {
        super.onException(e);
    }

    @Override
    public String getTransformer() {
        return this.transformer;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }
}

