/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.security.SaslChallenge;
import org.apache.qpid.proton.amqp.security.SaslCode;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.amqp.security.SaslInit;
import org.apache.qpid.proton.amqp.security.SaslMechanisms;
import org.apache.qpid.proton.amqp.security.SaslOutcome;
import org.apache.qpid.proton.amqp.security.SaslResponse;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.impl.SaslFrameParser;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public class SaslImpl
implements Sasl,
SaslFrameBody.SaslFrameBodyHandler<Void> {
    public static final byte SASL_FRAME_TYPE = 1;
    public static final byte[] HEADER = new byte[]{65, 77, 81, 80, 3, 1, 0, 0};
    private ByteBuffer _pending;
    private final DecoderImpl _decoder = new DecoderImpl();
    private final EncoderImpl _encoder = new EncoderImpl(this._decoder);
    private int _maxFrameSize = 4096;
    private final ByteBuffer _overflowBuffer = ByteBuffer.wrap(new byte[this._maxFrameSize]);
    private boolean _headerWritten;
    private Binary _challengeResponse;
    private SaslFrameParser _frameParser;
    private boolean _initReceived;
    private boolean _mechanismsSent;
    private boolean _initSent;
    private Sasl.SaslOutcome _outcome = Sasl.SaslOutcome.PN_SASL_NONE;
    private Sasl.SaslState _state = Sasl.SaslState.PN_SASL_IDLE;
    private String _hostname;
    private boolean _done;
    private Symbol[] _mechanisms;
    private Symbol _chosenMechanism;
    private Role _role;

    public SaslImpl() {
        this._frameParser = new SaslFrameParser(this);
        AMQPDefinedTypes.registerAllTypes(this._decoder, this._encoder);
        this._overflowBuffer.flip();
    }

    boolean isDone() {
        return this._done && (this._role == Role.CLIENT || this._initReceived);
    }

    @Override
    public final int input(byte[] bytes, int offset, int size2) {
        if (this.isDone()) {
            return -1;
        }
        return this.getFrameParser().input(bytes, offset, size2);
    }

    @Override
    public final int output(byte[] bytes, int offset, int size2) {
        int written = 0;
        if (this._overflowBuffer.hasRemaining()) {
            int overflowWritten = Math.min(size2, this._overflowBuffer.remaining());
            this._overflowBuffer.get(bytes, offset, overflowWritten);
            written += overflowWritten;
        }
        if (!this._overflowBuffer.hasRemaining()) {
            this._overflowBuffer.rewind();
            CompositeWritableBuffer outputBuffer = new CompositeWritableBuffer(new WritableBuffer.ByteBufferWrapper(ByteBuffer.wrap(bytes, offset + written, size2 - written)), new WritableBuffer.ByteBufferWrapper(this._overflowBuffer));
            written += this.process(outputBuffer);
        }
        return written;
    }

    protected int process(WritableBuffer buffer) {
        int written = this.processHeader(buffer);
        if (this._role == Role.SERVER) {
            if (!this._mechanismsSent && this._mechanisms != null) {
                SaslMechanisms mechanisms = new SaslMechanisms();
                mechanisms.setSaslServerMechanisms(this._mechanisms);
                written += this.writeFrame(buffer, mechanisms);
                this._mechanismsSent = true;
                this._state = Sasl.SaslState.PN_SASL_STEP;
            }
            if (this.getState() == Sasl.SaslState.PN_SASL_STEP && this.getChallengeResponse() != null) {
                SaslChallenge challenge = new SaslChallenge();
                challenge.setChallenge(this.getChallengeResponse());
                written += this.writeFrame(buffer, challenge);
                this.setChallengeResponse(null);
            }
            if (this._done) {
                SaslOutcome outcome = new SaslOutcome();
                outcome.setCode(SaslCode.values()[this._outcome.getCode()]);
                written += this.writeFrame(buffer, outcome);
            }
        } else if (this._role == Role.CLIENT) {
            if (this.getState() == Sasl.SaslState.PN_SASL_IDLE && this._chosenMechanism != null) {
                written += this.processInit(buffer);
                this._state = Sasl.SaslState.PN_SASL_STEP;
            }
            if (this.getState() == Sasl.SaslState.PN_SASL_STEP && this.getChallengeResponse() != null) {
                written += this.processResponse(buffer);
            }
        }
        return written;
    }

    int writeFrame(WritableBuffer buffer, SaslFrameBody frameBody) {
        int oldPosition = buffer.position();
        buffer.position(buffer.position() + 8);
        this._encoder.setByteBuffer(buffer);
        this._encoder.writeObject(frameBody);
        int frameSize = buffer.position() - oldPosition;
        int limit = buffer.position();
        buffer.position(oldPosition);
        buffer.putInt(frameSize);
        buffer.put((byte)2);
        buffer.put((byte)1);
        buffer.putShort((short)0);
        buffer.position(limit);
        return frameSize;
    }

    @Override
    public final int recv(byte[] bytes, int offset, int size2) {
        if (this._pending == null) {
            return -1;
        }
        int written = Math.min(size2, this._pending.remaining());
        this._pending.get(bytes, offset, written);
        if (!this._pending.hasRemaining()) {
            this._pending = null;
        }
        return written;
    }

    @Override
    public final int send(byte[] bytes, int offset, int size2) {
        byte[] data = new byte[size2];
        System.arraycopy(bytes, offset, data, 0, size2);
        this.setChallengeResponse(new Binary(data));
        return size2;
    }

    final int processHeader(WritableBuffer outputBuffer) {
        if (!this._headerWritten) {
            outputBuffer.put(HEADER, 0, HEADER.length);
            this._headerWritten = true;
            return HEADER.length;
        }
        return 0;
    }

    @Override
    public int pending() {
        return this._pending == null ? 0 : this._pending.remaining();
    }

    void setPending(ByteBuffer pending) {
        this._pending = pending;
    }

    @Override
    public Sasl.SaslState getState() {
        return this._state;
    }

    final DecoderImpl getDecoder() {
        return this._decoder;
    }

    final Binary getChallengeResponse() {
        return this._challengeResponse;
    }

    final void setChallengeResponse(Binary challengeResponse) {
        this._challengeResponse = challengeResponse;
    }

    final SaslFrameParser getFrameParser() {
        return this._frameParser;
    }

    @Override
    public void setMechanisms(String[] mechanisms) {
        if (mechanisms != null) {
            this._mechanisms = new Symbol[mechanisms.length];
            for (int i = 0; i < mechanisms.length; ++i) {
                this._mechanisms[i] = Symbol.valueOf(mechanisms[i]);
            }
        }
        if (this._role == Role.CLIENT) {
            assert (mechanisms != null);
            assert (mechanisms.length == 1);
            this._chosenMechanism = Symbol.valueOf(mechanisms[0]);
        }
    }

    @Override
    public String[] getRemoteMechanisms() {
        if (this._role == Role.SERVER) {
            String[] stringArray;
            if (this._chosenMechanism == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._chosenMechanism.toString();
            }
            return stringArray;
        }
        if (this._role == Role.CLIENT) {
            if (this._mechanisms == null) {
                return new String[0];
            }
            String[] remoteMechanisms = new String[this._mechanisms.length];
            for (int i = 0; i < this._mechanisms.length; ++i) {
                remoteMechanisms[i] = this._mechanisms[i].toString();
            }
            return remoteMechanisms;
        }
        throw new IllegalStateException();
    }

    public void setMechanism(Symbol mechanism) {
        this._chosenMechanism = mechanism;
    }

    public Symbol getChosenMechanism() {
        return this._chosenMechanism;
    }

    public void setResponse(Binary initialResponse) {
        this.setPending(initialResponse.asByteBuffer());
    }

    @Override
    public void handleInit(SaslInit saslInit, Binary payload, Void context) {
        if (this._role == null) {
            this.server();
        }
        this.checkRole(Role.SERVER);
        this._hostname = saslInit.getHostname();
        this._chosenMechanism = saslInit.getMechanism();
        this._initReceived = true;
        if (saslInit.getInitialResponse() != null) {
            this.setPending(saslInit.getInitialResponse().asByteBuffer());
        }
    }

    @Override
    public void handleResponse(SaslResponse saslResponse, Binary payload, Void context) {
        this.checkRole(Role.SERVER);
        this.setPending(saslResponse.getResponse() == null ? null : saslResponse.getResponse().asByteBuffer());
    }

    @Override
    public void done(Sasl.SaslOutcome outcome) {
        this.checkRole(Role.SERVER);
        this._outcome = outcome;
        this._done = true;
        this._state = outcome == Sasl.SaslOutcome.PN_SASL_OK ? Sasl.SaslState.PN_SASL_PASS : Sasl.SaslState.PN_SASL_FAIL;
    }

    private void checkRole(Role role) {
        if (role != this._role) {
            throw new IllegalStateException("Role is " + (Object)((Object)this._role) + " but should be " + (Object)((Object)role));
        }
    }

    @Override
    public void handleMechanisms(SaslMechanisms saslMechanisms, Binary payload, Void context) {
        if (this._role == null) {
            this.client();
        }
        this.checkRole(Role.CLIENT);
        this._mechanisms = saslMechanisms.getSaslServerMechanisms();
    }

    @Override
    public void handleChallenge(SaslChallenge saslChallenge, Binary payload, Void context) {
        this.checkRole(Role.CLIENT);
        this.setPending(saslChallenge.getChallenge() == null ? null : saslChallenge.getChallenge().asByteBuffer());
    }

    @Override
    public void handleOutcome(SaslOutcome saslOutcome, Binary payload, Void context) {
        this.checkRole(Role.CLIENT);
        for (Sasl.SaslOutcome outcome : Sasl.SaslOutcome.values()) {
            if (outcome.getCode() != saslOutcome.getCode().ordinal()) continue;
            this._outcome = outcome;
            break;
        }
        this._done = true;
    }

    private int processResponse(WritableBuffer buffer) {
        SaslResponse response = new SaslResponse();
        response.setResponse(this.getChallengeResponse());
        this.setChallengeResponse(null);
        return this.writeFrame(buffer, response);
    }

    private int processInit(WritableBuffer buffer) {
        SaslInit init = new SaslInit();
        init.setHostname(this._hostname);
        init.setMechanism(this._chosenMechanism);
        if (this.getChallengeResponse() != null) {
            init.setInitialResponse(this.getChallengeResponse());
            this.setChallengeResponse(null);
        }
        this._initSent = true;
        return this.writeFrame(buffer, init);
    }

    @Override
    public void plain(String username, String password) {
        this.client();
        this._chosenMechanism = Symbol.valueOf("PLAIN");
        byte[] usernameBytes = username.getBytes();
        byte[] passwordBytes = password.getBytes();
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(usernameBytes, 0, data, 1, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + usernameBytes.length, passwordBytes.length);
        this.setChallengeResponse(new Binary(data));
    }

    @Override
    public Sasl.SaslOutcome getOutcome() {
        return this._outcome;
    }

    @Override
    public void client() {
        this._role = Role.CLIENT;
        if (this._mechanisms != null) {
            assert (this._mechanisms.length == 1);
            this._chosenMechanism = this._mechanisms[0];
        }
    }

    @Override
    public void server() {
        this._role = Role.SERVER;
    }

    public TransportWrapper wrap(final TransportInput input, final TransportOutput output) {
        return new TransportWrapper(){
            private boolean _outputComplete;

            @Override
            public int input(byte[] bytes, int offset, int size2) {
                if (SaslImpl.this._role == null || SaslImpl.this._role == Role.CLIENT && !SaslImpl.this._done || SaslImpl.this._role == Role.SERVER && (!SaslImpl.this._initReceived || !SaslImpl.this._done)) {
                    return SaslImpl.this.input(bytes, offset, size2);
                }
                return input.input(bytes, offset, size2);
            }

            @Override
            public int output(byte[] bytes, int offset, int size2) {
                if (SaslImpl.this._role == null || SaslImpl.this._role == Role.CLIENT && (!SaslImpl.this._done || !SaslImpl.this._initSent) || SaslImpl.this._role == Role.SERVER && !this._outputComplete) {
                    int written = SaslImpl.this.output(bytes, offset, size2);
                    if (SaslImpl.this._done && !SaslImpl.this._overflowBuffer.hasRemaining()) {
                        this._outputComplete = true;
                    }
                    return written;
                }
                return output.output(bytes, offset, size2);
            }
        };
    }

    static enum Role {
        CLIENT,
        SERVER;

    }
}

