/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import org.iq80.leveldb.table.BlockEntry;
import org.iq80.leveldb.util.DynamicSliceOutput;
import org.iq80.leveldb.util.IntVector;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.VariableLengthQuantity;

public class BlockBuilder {
    private final int blockRestartInterval;
    private final IntVector restartPositions;
    private final Comparator<Slice> comparator;
    private int entryCount;
    private int restartBlockEntryCount;
    private boolean finished;
    private final DynamicSliceOutput block;
    private Slice lastKey;

    public BlockBuilder(int estimatedSize, int blockRestartInterval, Comparator<Slice> comparator) {
        Preconditions.checkArgument(estimatedSize >= 0, "estimatedSize is negative");
        Preconditions.checkArgument(blockRestartInterval >= 0, "blockRestartInterval is negative");
        Preconditions.checkNotNull(comparator, "comparator is null");
        this.block = new DynamicSliceOutput(estimatedSize);
        this.blockRestartInterval = blockRestartInterval;
        this.comparator = comparator;
        this.restartPositions = new IntVector(32);
        this.restartPositions.add(0);
    }

    public void reset() {
        this.block.reset();
        this.entryCount = 0;
        this.restartPositions.clear();
        this.restartPositions.add(0);
        this.restartBlockEntryCount = 0;
        this.lastKey = null;
        this.finished = false;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public boolean isEmpty() {
        return this.entryCount == 0;
    }

    public int currentSizeEstimate() {
        if (this.finished) {
            return this.block.size();
        }
        if (this.block.size() == 0) {
            return 4;
        }
        return this.block.size() + this.restartPositions.size() * 4 + 4;
    }

    public void add(BlockEntry blockEntry) {
        Preconditions.checkNotNull(blockEntry, "blockEntry is null");
        this.add(blockEntry.getKey(), blockEntry.getValue());
    }

    public void add(Slice key, Slice value) {
        Preconditions.checkNotNull(key, "key is null");
        Preconditions.checkNotNull(value, "value is null");
        Preconditions.checkState(!this.finished, "block is finished");
        Preconditions.checkPositionIndex(this.restartBlockEntryCount, this.blockRestartInterval);
        Preconditions.checkArgument(this.lastKey == null || this.comparator.compare(key, this.lastKey) > 0, "key must be greater than last key");
        int sharedKeyBytes = 0;
        if (this.restartBlockEntryCount < this.blockRestartInterval) {
            sharedKeyBytes = BlockBuilder.calculateSharedBytes(key, this.lastKey);
        } else {
            this.restartPositions.add(this.block.size());
            this.restartBlockEntryCount = 0;
        }
        int nonSharedKeyBytes = key.length() - sharedKeyBytes;
        VariableLengthQuantity.writeVariableLengthInt(sharedKeyBytes, this.block);
        VariableLengthQuantity.writeVariableLengthInt(nonSharedKeyBytes, this.block);
        VariableLengthQuantity.writeVariableLengthInt(value.length(), this.block);
        this.block.writeBytes(key, sharedKeyBytes, nonSharedKeyBytes);
        this.block.writeBytes(value, 0, value.length());
        this.lastKey = key;
        ++this.entryCount;
        ++this.restartBlockEntryCount;
    }

    public static int calculateSharedBytes(Slice leftKey, Slice rightKey) {
        int sharedKeyBytes;
        if (leftKey != null && rightKey != null) {
            int minSharedKeyBytes = Ints.min(leftKey.length(), rightKey.length());
            for (sharedKeyBytes = 0; sharedKeyBytes < minSharedKeyBytes && leftKey.getByte(sharedKeyBytes) == rightKey.getByte(sharedKeyBytes); ++sharedKeyBytes) {
            }
        }
        return sharedKeyBytes;
    }

    public Slice finish() {
        if (!this.finished) {
            this.finished = true;
            if (this.entryCount > 0) {
                this.restartPositions.write(this.block);
                this.block.writeInt(this.restartPositions.size());
            } else {
                this.block.writeInt(0);
            }
        }
        return this.block.slice();
    }
}

