/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Mac;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES128CTR;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.AES256CTR;
import org.apache.sshd.common.cipher.ARCFOUR128;
import org.apache.sshd.common.cipher.ARCFOUR256;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshUtils {
    public static <S> List<NamedFactory<S>> filter(Collection<NamedFactory<S>> factories, String names) {
        ArrayList<NamedFactory<S>> list = new ArrayList<NamedFactory<S>>();
        for (String name : names.split(",")) {
            for (NamedFactory<S> factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
            }
        }
        return list;
    }

    public static List<NamedFactory<Mac>> buildMacs(String names) {
        return SshUtils.filter(Arrays.asList(new HMACMD5.Factory(), new HMACSHA1.Factory(), new HMACMD596.Factory(), new HMACSHA196.Factory()), names);
    }

    public static List<NamedFactory<Cipher>> buildCiphers(String names) {
        List<NamedFactory<Cipher>> avail = new LinkedList();
        avail.add((NamedFactory<Cipher>)new AES128CTR.Factory());
        avail.add((NamedFactory<Cipher>)new AES256CTR.Factory());
        avail.add((NamedFactory<Cipher>)new ARCFOUR128.Factory());
        avail.add((NamedFactory<Cipher>)new ARCFOUR256.Factory());
        avail.add((NamedFactory<Cipher>)new AES128CBC.Factory());
        avail.add((NamedFactory<Cipher>)new TripleDESCBC.Factory());
        avail.add((NamedFactory<Cipher>)new BlowfishCBC.Factory());
        avail.add((NamedFactory<Cipher>)new AES192CBC.Factory());
        avail.add((NamedFactory<Cipher>)new AES256CBC.Factory());
        avail = SshUtils.filter(avail, names);
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        return avail;
    }
}

