/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="intercept")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptDefinition
extends OutputDefinition<InterceptDefinition> {
    @XmlTransient
    protected Processor output;
    @XmlTransient
    protected final List<Processor> intercepted = new ArrayList<Processor>();

    public String toString() {
        return "Intercept[" + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "intercept";
    }

    @Override
    public String getLabel() {
        return "intercept";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        this.output = this.createChildProcessor(routeContext, false);
        routeContext.getInterceptStrategies().add(new InterceptStrategy(){
            private Processor interceptedTarget;

            public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition definition, Processor target, Processor nextTarget) throws Exception {
                this.interceptedTarget = nextTarget != null ? nextTarget : target;
                InterceptDefinition.this.intercepted.add(this.interceptedTarget);
                if (this.interceptedTarget != null) {
                    ArrayList<Processor> list = new ArrayList<Processor>(2);
                    list.add(InterceptDefinition.this.output);
                    list.add(this.interceptedTarget);
                    return new Pipeline(context, list);
                }
                return InterceptDefinition.this.output;
            }

            public String toString() {
                return "intercept[" + (this.interceptedTarget != null ? this.interceptedTarget : InterceptDefinition.this.output) + "]";
            }
        });
        routeContext.getRoute().getOutputs().remove(this);
        return null;
    }

    public ChoiceDefinition when(Predicate predicate) {
        return this.choice().when(predicate);
    }

    public void afterPropertiesSet() {
        if (this.getOutputs().size() == 0) {
            return;
        }
        ProcessorDefinition first = this.getOutputs().get(0);
        if (first instanceof WhenDefinition) {
            WhenDefinition when = (WhenDefinition)first;
            for (int i = 1; i < this.outputs.size(); ++i) {
                ProcessorDefinition out = (ProcessorDefinition)this.outputs.get(i);
                when.addOutput(out);
            }
            ProcessorDefinition keep = (ProcessorDefinition)this.outputs.get(0);
            this.clearOutput();
            this.outputs.add(keep);
        }
    }

    public Processor getInterceptedProcessor(int index) {
        if (index <= this.intercepted.size() - 1) {
            return this.intercepted.get(index);
        }
        return null;
    }
}

