/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseOriginalAggregationStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter
extends MulticastProcessor
implements AsyncProcessor,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(Splitter.class);
    private final Expression expression;

    public Splitter(CamelContext camelContext, Expression expression, Processor destination, AggregationStrategy aggregationStrategy) {
        this(camelContext, expression, destination, aggregationStrategy, false, null, false, false, 0L);
    }

    public Splitter(CamelContext camelContext, Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming, boolean stopOnException, long timeout) {
        super(camelContext, Collections.singleton(destination), aggregationStrategy, parallelProcessing, executorService, streaming, stopOnException, timeout);
        this.expression = expression;
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(destination, "destination");
    }

    @Override
    public String toString() {
        return "Splitter[on: " + this.expression + " to: " + this.getProcessors().iterator().next() + " aggregate: " + this.getAggregationStrategy() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "split[" + this.expression + "]";
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null) {
            UseOriginalAggregationStrategy original = new UseOriginalAggregationStrategy(exchange, true);
            exchange.setProperty("CamelAggregationStrategy", original);
        }
        return super.process(exchange, callback);
    }

    @Override
    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) {
        Object value = this.expression.evaluate(exchange, Object.class);
        if (this.isStreaming()) {
            return this.createProcessorExchangePairsIterable(exchange, value);
        }
        return this.createProcessorExchangePairsList(exchange, value);
    }

    private Iterable<ProcessorExchangePair> createProcessorExchangePairsIterable(final Exchange exchange, final Object value) {
        final Iterator<Object> iterator = ObjectHelper.createIterator(value);
        return new Iterable(){

            public Iterator iterator() {
                return new Iterator(){
                    private int index;
                    private boolean closed;

                    public boolean hasNext() {
                        if (this.closed) {
                            return false;
                        }
                        boolean answer = iterator.hasNext();
                        if (!answer) {
                            this.closed = true;
                            if (value instanceof Closeable) {
                                IOHelper.close((Closeable)value, value.getClass().getName(), LOG);
                            } else if (value instanceof Scanner) {
                                ((Scanner)value).close();
                            }
                        }
                        return answer;
                    }

                    public Object next() {
                        Object part = iterator.next();
                        Exchange newExchange = exchange.copy();
                        if (part instanceof Message) {
                            newExchange.setIn((Message)part);
                        } else {
                            Message in = newExchange.getIn();
                            in.setBody(part);
                        }
                        return Splitter.this.createProcessorExchangePair(this.index++, Splitter.this.getProcessors().iterator().next(), newExchange);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not supported by this iterator");
                    }
                };
            }
        };
    }

    private Iterable<ProcessorExchangePair> createProcessorExchangePairsList(Exchange exchange, Object value) {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>();
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairsIterable(exchange, value);
        for (ProcessorExchangePair pair : pairs) {
            result.add(pair);
        }
        return result;
    }

    @Override
    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, Iterator<ProcessorExchangePair> it) {
        exchange.setUnitOfWork(null);
        exchange.setProperty("CamelSplitIndex", index);
        if (allPairs instanceof Collection) {
            exchange.setProperty("CamelSplitSize", ((Collection)allPairs).size());
        }
        if (it.hasNext()) {
            exchange.setProperty("CamelSplitComplete", Boolean.FALSE);
        } else {
            exchange.setProperty("CamelSplitComplete", Boolean.TRUE);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }
}

