/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Tracer")
public class ManagedTracer {
    private CamelContext camelContext;
    private Tracer tracer;

    public ManagedTracer(CamelContext camelContext, Tracer tracer) {
        this.camelContext = camelContext;
        this.tracer = tracer;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @ManagedAttribute(description="Tracer enabled")
    public boolean getEnabled() {
        return this.tracer.isEnabled();
    }

    @ManagedAttribute(description="Tracer enabled")
    public void setEnabled(boolean enabled) {
        this.tracer.setEnabled(enabled);
    }

    @ManagedAttribute(description="Additional destination Uri")
    public String getDestinationUri() {
        return this.tracer.getDestinationUri();
    }

    @ManagedAttribute(description="Additional destination Uri")
    public void setDestinationUri(String uri) {
        if (ObjectHelper.isEmpty(uri)) {
            this.tracer.setDestinationUri(null);
        } else {
            this.tracer.setDestinationUri(uri);
        }
    }

    @ManagedAttribute(description="Logging Name")
    public String getLogName() {
        return this.tracer.getLogName();
    }

    @ManagedAttribute(description="Using Jpa")
    public boolean getUseJpa() {
        return this.tracer.isUseJpa();
    }

    @ManagedAttribute(description="Logging Name")
    public void setLogName(String logName) {
        this.tracer.setLogName(logName);
    }

    @ManagedAttribute(description="Logging Level")
    public String getLogLevel() {
        return this.tracer.getLogLevel().name();
    }

    @ManagedAttribute(description="Logging Level")
    public void setLogLevel(String logLevel) {
        this.tracer.setLogLevel(LoggingLevel.valueOf(logLevel));
    }

    @ManagedAttribute(description="Log Stacktrace")
    public boolean getLogStackTrace() {
        return this.tracer.isLogStackTrace();
    }

    @ManagedAttribute(description="Log Stacktrace")
    public void setLogStackTrace(boolean logStackTrace) {
        this.tracer.setLogStackTrace(logStackTrace);
    }

    @ManagedAttribute(description="Trace Interceptors")
    public boolean getTraceInterceptors() {
        return this.tracer.isTraceInterceptors();
    }

    @ManagedAttribute(description="Trace Interceptors")
    public void setTraceInterceptors(boolean traceInterceptors) {
        this.tracer.setTraceInterceptors(traceInterceptors);
    }

    @ManagedAttribute(description="Trace Exceptions")
    public boolean getTraceExceptions() {
        return this.tracer.isTraceExceptions();
    }

    @ManagedAttribute(description="Trace Exceptions")
    public void setTraceExceptions(boolean traceExceptions) {
        this.tracer.setTraceExceptions(traceExceptions);
    }

    @ManagedAttribute(description="Trace Out Exchanges")
    public boolean getTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    @ManagedAttribute(description="Trace Out Exchanges")
    public void setTraceOutExchanges(boolean traceOutExchanges) {
        this.tracer.setTraceOutExchanges(traceOutExchanges);
    }

    @ManagedAttribute(description="Formatter show body")
    public boolean getFormatterShowBody() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowBody();
    }

    @ManagedAttribute(description="Formatter show body")
    public void setFormatterShowBody(boolean showBody) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowBody(showBody);
    }

    @ManagedAttribute(description="Formatter show body type")
    public boolean getFormatterShowBodyType() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowBodyType();
    }

    @ManagedAttribute(description="Formatter show body type")
    public void setFormatterShowBodyType(boolean showBodyType) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowBodyType(showBodyType);
    }

    @ManagedAttribute(description="Formatter show out body")
    public boolean getFormatterShowOutBody() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowOutBody();
    }

    @ManagedAttribute(description="Formatter show out body")
    public void setFormatterShowOutBody(boolean showOutBody) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowOutBody(showOutBody);
    }

    @ManagedAttribute(description="Formatter show out body type")
    public boolean getFormatterShowOutBodyType() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowOutBodyType();
    }

    @ManagedAttribute(description="Formatter show out body type")
    public void setFormatterShowOutBodyType(boolean showOutBodyType) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowOutBodyType(showOutBodyType);
    }

    @ManagedAttribute(description="Formatter show breadcrumb")
    public boolean getFormatterShowBreadCrumb() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowBreadCrumb();
    }

    @ManagedAttribute(description="Formatter show breadcrumb")
    public void setFormatterShowBreadCrumb(boolean showBreadCrumb) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowBreadCrumb(showBreadCrumb);
    }

    @ManagedAttribute(description="Formatter show exchange id")
    public boolean getFormatterShowExchangeId() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowExchangeId();
    }

    @ManagedAttribute(description="Formatter show exchange id")
    public void setFormatterShowExchangeId(boolean showExchangeId) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowExchangeId(showExchangeId);
    }

    @ManagedAttribute(description="Formatter show headers")
    public boolean getFormatterShowHeaders() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowHeaders();
    }

    @ManagedAttribute(description="Formatter show headers")
    public void setFormatterShowHeaders(boolean showHeaders) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowHeaders(showHeaders);
    }

    @ManagedAttribute(description="Formatter show out headers")
    public boolean getFormatterShowOutHeaders() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowOutHeaders();
    }

    @ManagedAttribute(description="Formatter show out headers")
    public void setFormatterShowOutHeaders(boolean showOutHeaders) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowOutHeaders(showOutHeaders);
    }

    @ManagedAttribute(description="Formatter show properties")
    public boolean getFormatterShowProperties() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowProperties();
    }

    @ManagedAttribute(description="Formatter show properties")
    public void setFormatterShowProperties(boolean showProperties) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowProperties(showProperties);
    }

    @ManagedAttribute(description="Formatter show node")
    public boolean getFormatterShowNode() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowNode();
    }

    @ManagedAttribute(description="Formatter show node")
    public void setFormatterShowNode(boolean showNode) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowNode(showNode);
    }

    @ManagedAttribute(description="Formatter show exchange pattern")
    public boolean getFormatterShowExchangePattern() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowExchangePattern();
    }

    @ManagedAttribute(description="Formatter show exchange pattern")
    public void setFormatterShowExchangePattern(boolean showExchangePattern) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowExchangePattern(showExchangePattern);
    }

    @ManagedAttribute(description="Formatter show exception")
    public boolean getFormatterShowException() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowException();
    }

    @ManagedAttribute(description="Formatter show exception")
    public void setFormatterShowException(boolean showException) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowException(showException);
    }

    @ManagedAttribute(description="Formatter show route id")
    public boolean getFormatterShowRouteId() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowRouteId();
    }

    @ManagedAttribute(description="Formatter show route id")
    public void setFormatterShowRouteId(boolean showRouteId) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowRouteId(showRouteId);
    }

    @ManagedAttribute(description="Formatter breadcrumb length")
    public int getFormatterBreadCrumbLength() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return 0;
        }
        return this.tracer.getDefaultTraceFormatter().getBreadCrumbLength();
    }

    @ManagedAttribute(description="Formatter breadcrumb length")
    public void setFormatterBreadCrumbLength(int breadCrumbLength) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setBreadCrumbLength(breadCrumbLength);
    }

    @ManagedAttribute(description="Formatter show short exchange id")
    public boolean getFormatterShowShortExchangeId() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowShortExchangeId();
    }

    @ManagedAttribute(description="Formatter show short exchange id")
    public void setFormatterShowShortExchangeId(boolean showShortExchangeId) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowShortExchangeId(showShortExchangeId);
    }

    @ManagedAttribute(description="Formatter node length")
    public int getFormatterNodeLength() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return 0;
        }
        return this.tracer.getDefaultTraceFormatter().getNodeLength();
    }

    @ManagedAttribute(description="Formatter node length")
    public void setFormatterNodeLength(int nodeLength) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setNodeLength(nodeLength);
    }

    @ManagedAttribute(description="Formatter max chars")
    public int getFormatterMaxChars() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return 0;
        }
        return this.tracer.getDefaultTraceFormatter().getMaxChars();
    }

    @ManagedAttribute(description="Formatter max chars")
    public void setFormatterMaxChars(int maxChars) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setMaxChars(maxChars);
    }
}

