/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Traceable;

public class SetBodyProcessor
extends DelegateProcessor
implements Traceable {
    private final Expression expression;

    public SetBodyProcessor(Expression expression) {
        this.expression = expression;
    }

    public SetBodyProcessor(Expression expression, Processor childProcessor) {
        super(childProcessor);
        this.expression = expression;
    }

    public void process(Exchange exchange) throws Exception {
        Object newBody = this.expression.evaluate(exchange, Object.class);
        Message old = exchange.getIn();
        DefaultMessage msg = new DefaultMessage();
        msg.copyFrom(old);
        msg.setBody(newBody);
        exchange.setIn(msg);
        super.process(exchange);
    }

    public String toString() {
        return "SetBody(" + this.expression + (this.processor != null ? "," + this.processor : "") + ")";
    }

    public String getTraceLabel() {
        return "setBody[" + this.expression + "]";
    }
}

