/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ExecutorServiceHelper {
    private static AtomicInteger threadCounter = new AtomicInteger();

    private ExecutorServiceHelper() {
    }

    public static String getThreadName(String name) {
        return "Camel thread " + ExecutorServiceHelper.nextThreadCounter() + ": " + name;
    }

    protected static synchronized int nextThreadCounter() {
        return threadCounter.getAndIncrement();
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, final String name, final boolean daemon) {
        return Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newFixedThreadPool(int poolSize, final String name, final boolean daemon) {
        return Executors.newFixedThreadPool(poolSize, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newSingleThreadExecutor(final String name, final boolean daemon) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }

    public static ExecutorService newCachedThreadPool(final String name, final boolean daemon) {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread answer = new Thread(r, ExecutorServiceHelper.getThreadName(name));
                answer.setDaemon(daemon);
                return answer;
            }
        });
    }
}

