/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.client;

import io.fabric8.patch.impl.Offline;
import java.io.File;

public class Main {
    private static void help() {
        System.out.println("Usage: bin/patch patch-file [karaf-base]");
        System.out.println("   patch-file: location of patch file to apply");
        System.out.println("   karaf-base: directory of the karaf installation");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Main.help();
            return;
        }
        File patch = new File(args[0]);
        if (!patch.isFile()) {
            System.err.println("Invalid patch file");
            return;
        }
        File base = args.length > 1 ? new File(args[1]) : new File(System.getProperty("karaf.base"));
        if (!new File(base, "system").isDirectory() || !new File(base, "etc").isDirectory()) {
            System.err.println("Invalid karaf-base parameter");
            return;
        }
        new Offline(base).apply(patch);
    }
}

