/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumUtils {
    public static final String FOLDER_CHECKSUM_CACHE = ".fabric8.checksums.properties";
    private static final transient Logger LOG = LoggerFactory.getLogger(ChecksumUtils.class);

    private ChecksumUtils() {
    }

    public static long checksum(File file) throws IOException {
        return ChecksumUtils.checksum(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksum(InputStream is) throws IOException {
        try {
            int l;
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[8192];
            while ((l = is.read(buffer)) > 0) {
                crc.update(buffer, 0, l);
            }
            long l2 = crc.getValue();
            return l2;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static long checksumFile(File file) throws IOException {
        return ChecksumUtils.checksum(new FileInputStream(file));
    }

    public static Map<File, Long> loadInstalledChecksumCache(File dir) {
        HashMap<File, Long> answer = new HashMap<File, Long>();
        File cacheFile = new File(dir, FOLDER_CHECKSUM_CACHE);
        if (cacheFile.exists() && cacheFile.isFile()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileReader(cacheFile));
            }
            catch (IOException e) {
                LOG.warn("Failed to load checksum cache file " + cacheFile + ". " + e, (Throwable)e);
            }
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                Object key = entry.getKey();
                if (key == null) continue;
                String keyText = key.toString();
                Object value = entry.getValue();
                if (value == null) continue;
                String valueText = value.toString();
                try {
                    long number = Long.parseLong(valueText);
                    answer.put(new File(dir, keyText), number);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Failed to parse checksum '" + valueText + "' in " + cacheFile + ". " + e, (Throwable)e);
                }
            }
        }
        return answer;
    }

    public static void saveInstalledChecksumCache(File dir, Map<File, Long> checksums) throws IOException {
        File cacheFile = new File(dir, FOLDER_CHECKSUM_CACHE);
        Properties properties = new Properties();
        Set<Map.Entry<File, Long>> entries = checksums.entrySet();
        for (Map.Entry<File, Long> entry : entries) {
            properties.put(entry.getKey().getName(), "" + entry.getValue());
        }
        properties.store(new FileWriter(cacheFile), "Updated on " + new Date());
    }

    public static class CRCInputStream
    extends FilterInputStream {
        private final CRC32 crc = new CRC32();

        public CRCInputStream(InputStream in) {
            super(in);
        }

        public long getCRC() {
            return this.crc.getValue();
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int nb = this.read(b, 0, 1);
            return nb == 1 ? b[0] : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nb = super.read(b, off, len);
            if (nb > 0) {
                this.crc.update(b, off, nb);
            }
            return nb;
        }
    }
}

