/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test.util;

import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.junit.Assert;

public abstract class TestProvisionedConfigHandler
implements ProvisionedConfigHandler {
    private static final String BATCH_START = "START BATCH";
    private static final String BATCH_END = "END BATCH";
    private static final String BRANCH_START = "START BRANCH";
    private static final String BRANCH_END = "END BRANCH";
    protected final boolean logEvents = this.loggingEnabled();
    private int i = 0;
    private final String[] events;
    private final boolean branchesOn = this.branchesEnabled();

    protected static String batchStartEvent() {
        return BATCH_START;
    }

    protected static String batchEndEvent() {
        return BATCH_END;
    }

    protected static String branchStartEvent() {
        return BRANCH_START;
    }

    protected static String branchEndEvent() {
        return BRANCH_END;
    }

    protected static String featurePackEvent(FeaturePackLocation.FPID fpid) {
        return "feature-pack " + fpid;
    }

    protected static String specEvent(String spec) {
        return " spec " + spec;
    }

    protected static String featureEvent(ResolvedFeatureId id) {
        return "  " + id;
    }

    protected TestProvisionedConfigHandler() {
        try {
            this.events = this.initEvents();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize events", e);
        }
    }

    protected boolean loggingEnabled() {
        return false;
    }

    protected boolean branchesEnabled() {
        return false;
    }

    protected abstract String[] initEvents() throws Exception;

    public void prepare(ProvisionedConfig config) {
        this.i = 0;
    }

    public void startBranch() {
        if (this.branchesOn) {
            this.assertNextEvent(TestProvisionedConfigHandler.branchStartEvent());
        }
    }

    public void endBranch() {
        if (this.branchesOn) {
            this.assertNextEvent(TestProvisionedConfigHandler.branchEndEvent());
        }
    }

    public void startBatch() {
        this.assertNextEvent(TestProvisionedConfigHandler.batchStartEvent());
    }

    public void endBatch() {
        this.assertNextEvent(TestProvisionedConfigHandler.batchEndEvent());
    }

    public void nextFeaturePack(FeaturePackLocation.FPID fpid) {
        this.assertNextEvent(TestProvisionedConfigHandler.featurePackEvent(fpid));
    }

    public void nextSpec(ResolvedFeatureSpec spec) {
        this.assertNextEvent(TestProvisionedConfigHandler.specEvent(spec.getName()));
    }

    public void nextFeature(ProvisionedFeature feature) {
        this.assertNextEvent(TestProvisionedConfigHandler.featureEvent(feature.getId()));
    }

    private void assertNextEvent(String actual) {
        if (this.logEvents) {
            System.out.println(actual);
        }
        Assert.assertTrue((String)"There are more events than expected", (this.i < this.events.length ? 1 : 0) != 0);
        Assert.assertEquals((String)("Event " + (this.i + 1)), (Object)this.events[this.i++], (Object)actual);
    }
}

