/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test.util.fs.state;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.galleon.api.test.util.TestUtils;
import org.jboss.galleon.api.test.util.fs.state.PathState;
import org.junit.Assert;

public class FileContentState
extends PathState {
    private final String content;

    public static FileContentBuilder builder(String name, String content) {
        return new FileContentBuilder(name, content);
    }

    protected FileContentState(String name, String content) {
        super(name);
        this.content = content;
    }

    @Override
    protected void doAssertState(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Assert.fail((String)("Path is a not directory: " + path));
        }
        if (!this.content.equals(TestUtils.read(path))) {
            Assert.fail((String)(path + " expected to contain " + this.content + " instead of " + TestUtils.read(path)));
        }
    }

    public static class FileContentBuilder
    extends PathState.Builder {
        private final String content;

        private FileContentBuilder(String name, String content) {
            super(name);
            this.content = content;
        }

        @Override
        public FileContentState build() {
            return new FileContentState(this.name, this.content);
        }
    }
}

