/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.GalleonProvisioningLayout;
import org.jboss.galleon.api.GalleonProvisioningRuntime;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.ProvisioningBuilder;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilderItf;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.core.builder.LocalFP;
import org.jboss.galleon.core.builder.ProvisioningContext;
import org.jboss.galleon.core.builder.ProvisioningContextBuilder;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.impl.ProvisioningUtil;
import org.jboss.galleon.progresstracking.DefaultProgressTracker;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;

class ProvisioningImpl
implements Provisioning {
    private final Path home;
    private final MessageWriter log;
    private boolean logTime;
    private final UniverseResolver universeResolver;
    private boolean recordState;
    private final Map<String, ProgressTracker<?>> progressTrackers = new HashMap();
    private final Path tmp;
    private final Map<FeaturePackLocation.FPID, LocalFP> locals;
    private final String coreVersion;
    private final URLClassLoader loader;
    private final List<ProvisioningContext> contexts = new ArrayList<ProvisioningContext>();

    ProvisioningImpl(ProvisioningBuilder builder) throws ProvisioningException {
        this.home = builder.getInstallationHome();
        this.log = builder.getMessageWriter() == null ? DefaultMessageWriter.getDefaultInstance() : builder.getMessageWriter();
        this.coreVersion = builder.getGalleonCoreVersion();
        this.universeResolver = builder.getUniverseResolver();
        this.logTime = builder.isLogTime();
        this.locals = builder.getLocals();
        this.recordState = builder.isRecordState();
        this.loader = GalleonBuilder.getCallerClassLoader(this.coreVersion, this.universeResolver);
        try {
            this.tmp = Files.createTempDirectory("galleon-tmp", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public Path getInstallationHome() {
        return this.home;
    }

    @Override
    public boolean isLogTime() {
        return this.logTime;
    }

    @Override
    public boolean isRecordState() {
        return this.recordState;
    }

    @Override
    public void setProgressCallback(String id, ProgressCallback<?> callback) {
        if (callback == null) {
            this.progressTrackers.remove(id);
        } else {
            this.progressTrackers.put(id, (ProgressTracker<?>)new DefaultProgressTracker(callback));
        }
    }

    @Override
    public void setProgressTracker(String id, ProgressTracker<?> tracker) {
        if (tracker == null) {
            this.progressTrackers.remove(id);
        } else {
            this.progressTrackers.put(id, tracker);
        }
    }

    private ProvisioningContext buildProvisioningContext() throws ProvisioningException {
        try {
            Class callerClass = ProvisioningUtil.getCallerClass((URLClassLoader)this.loader);
            try {
                ProvisioningContextBuilder provisioner = (ProvisioningContextBuilder)callerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                ProvisioningContext ctx = provisioner.buildProvisioningContext(this.loader, this.home, this.log, this.logTime, this.recordState, this.universeResolver, this.progressTrackers, this.locals);
                this.contexts.add(ctx);
                return ctx;
            }
            catch (Exception ex) {
                if (ex instanceof ProvisioningException) {
                    throw (ProvisioningException)ex;
                }
                throw new ProvisioningException((Throwable)ex);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ProvisioningException) {
                throw (ProvisioningException)ex;
            }
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public void close() {
        IoUtils.recursiveDelete((Path)this.tmp);
        try {
            for (ProvisioningContext ctx : this.contexts) {
                ctx.close();
            }
        }
        finally {
            try {
                GalleonBuilder.releaseUsage(this.coreVersion);
            }
            catch (ProvisioningException ex) {
                System.err.println("Error releasing classloader " + ex.getLocalizedMessage());
            }
        }
    }

    @Override
    public void addUniverse(String name, UniverseSpec universeSpec) throws ProvisioningException {
        GalleonProvisioningConfig config = ((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder((GalleonProvisioningConfig)this.getProvisioningConfig()).addUniverse(name, universeSpec)).build();
        try {
            this.storeProvisioningConfig(config, PathsUtils.getProvisioningXml((Path)this.home));
        }
        catch (Exception e) {
            if (e instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)e);
            }
            throw new ProvisioningException(BaseErrors.writeFile((Path)PathsUtils.getProvisioningXml((Path)this.home)), (Throwable)e);
        }
    }

    @Override
    public void removeUniverse(String name) throws ProvisioningException {
        GalleonProvisioningConfig config = this.getProvisioningConfig();
        if (config == null || !config.hasUniverse(name)) {
            return;
        }
        config = ((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder((GalleonProvisioningConfig)config).removeUniverse(name)).build();
        try {
            this.storeProvisioningConfig(config, PathsUtils.getProvisioningXml((Path)this.home));
        }
        catch (Exception e) {
            if (e instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)e);
            }
            throw new ProvisioningException(BaseErrors.writeFile((Path)PathsUtils.getProvisioningXml((Path)this.home)), (Throwable)e);
        }
    }

    @Override
    public void setDefaultUniverse(UniverseSpec universeSpec) throws ProvisioningException {
        this.addUniverse(null, universeSpec);
    }

    @Override
    public GalleonProvisioningConfig getProvisioningConfig() throws ProvisioningException {
        if (this.home == null || !Files.exists(this.home, new LinkOption[0])) {
            throw new ProvisioningException(BaseErrors.homeDirNotUsable((Path)this.home));
        }
        Path provisioning = PathsUtils.getProvisioningXml((Path)this.home);
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.parseProvisioningFile(provisioning);
    }

    @Override
    public List<String> getInstalledPacks(Path dir) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.getInstalledPacks(dir);
    }

    @Override
    public GalleonProvisioningConfig loadProvisioningConfig(InputStream is) throws ProvisioningException {
        try {
            ProvisioningContext ctx = this.buildProvisioningContext();
            return ctx.loadProvisioningConfig(is);
        }
        catch (Exception ex) {
            if (ex instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)ex);
            }
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public void storeProvisioningConfig(GalleonProvisioningConfig config, Path target) throws ProvisioningException {
        try {
            ProvisioningContext ctx = this.buildProvisioningContext();
            ctx.storeProvisioningConfig(config, target);
        }
        catch (Exception ex) {
            if (ex instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)ex);
            }
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public void provision(GalleonProvisioningConfig config, List<Path> customConfigs, Map<String, String> options) throws ProvisioningException {
        try {
            ProvisioningContext ctx = this.buildProvisioningContext();
            ctx.provision(config, customConfigs, options);
        }
        catch (Exception ex) {
            if (ex instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)ex);
            }
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public void provision(Path config, Map<String, String> options) throws ProvisioningException {
        try {
            ProvisioningContext ctx = this.buildProvisioningContext();
            ctx.provision(config, options);
        }
        catch (Exception ex) {
            if (ex instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)ex);
            }
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public GalleonProvisioningRuntime getProvisioningRuntime(GalleonProvisioningConfig config) throws ProvisioningException {
        try {
            ProvisioningContext ctx = this.buildProvisioningContext();
            return ctx.getProvisioningRuntime(config);
        }
        catch (Exception ex) {
            if (ex instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)ex);
            }
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public GalleonConfigurationWithLayersBuilderItf buildConfigurationBuilder(GalleonConfigurationWithLayers config) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.buildConfigurationBuilder(config);
    }

    @Override
    public boolean hasOrderedFeaturePacksConfig(GalleonProvisioningConfig config, ConfigId cfg) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.hasOrderedFeaturePacksConfig(config, cfg);
    }

    @Override
    public Set<String> getOrderedFeaturePackPluginLocations(GalleonProvisioningConfig config) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.getOrderedFeaturePackPluginLocations(config);
    }

    @Override
    public FsDiff getFsDiff() throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.getFsDiff();
    }

    @Override
    public void install(FeaturePackLocation loc) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        ctx.install(loc);
    }

    @Override
    public void install(GalleonFeaturePackConfig config) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        ctx.install(config);
    }

    @Override
    public void uninstall(FeaturePackLocation.FPID loc) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        ctx.uninstall(loc);
    }

    @Override
    public GalleonProvisioningLayout newProvisioningLayout(GalleonProvisioningConfig config) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.newProvisioningLayout(config);
    }

    @Override
    public GalleonProvisioningLayout newProvisioningLayout(Path file, boolean install) throws ProvisioningException {
        ProvisioningContext ctx = this.buildProvisioningContext();
        return ctx.newProvisioningLayout(file, install);
    }

    @Override
    public UniverseResolver getUniverseResolver() {
        return this.universeResolver;
    }
}

