/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test.util.fs.state;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.galleon.api.test.util.TestUtils;
import org.jboss.galleon.api.test.util.fs.state.FileContentState;
import org.jboss.galleon.api.test.util.fs.state.PathState;
import org.jboss.galleon.api.test.util.fs.state.SkipPathState;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.PathsUtils;
import org.junit.Assert;

public class DirState
extends PathState {
    public static final String SEPARATOR = "/";
    private final Map<String, PathState> childStates;

    public static DirBuilder rootBuilder() {
        return DirState.builder(null);
    }

    public static DirBuilder builder(String name) {
        return new DirBuilder(name);
    }

    private DirState(String name, Map<String, PathState> states) {
        super(name);
        this.childStates = states;
    }

    @Override
    public void assertState(Path root) {
        if (this.name == null) {
            this.doAssertState(root);
        } else {
            super.assertState(root);
        }
    }

    @Override
    protected void doAssertState(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Assert.fail((String)("Path is a directory: " + path));
        }
        HashSet<String> actualPaths = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path child : stream) {
                actualPaths.add(child.getFileName().toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read directory " + path, e);
        }
        for (Map.Entry<String, PathState> entry : this.childStates.entrySet()) {
            entry.getValue().assertState(path);
            actualPaths.remove(entry.getKey());
        }
        if (!actualPaths.isEmpty()) {
            Assert.fail((String)("Dir " + path + " does not contain " + actualPaths));
        }
    }

    public static class DirBuilder
    extends PathState.Builder {
        private Map<String, PathState.Builder> childStates = Collections.emptyMap();

        private DirBuilder(String name) {
            super(name);
        }

        private DirBuilder addState(String name, PathState.Builder state) {
            this.childStates = CollectionUtils.put(this.childStates, (Object)name, (Object)state);
            return this;
        }

        public DirBuilder addDir(String relativePath) {
            DirBuilder dirBuilder = this;
            String[] parts = relativePath.split(DirState.SEPARATOR);
            int i = 0;
            while (i < parts.length) {
                dirBuilder = dirBuilder.dirBuilder(parts[i++]);
            }
            return this;
        }

        public DirBuilder addFile(String relativePath, String content) {
            DirBuilder dirBuilder = this;
            String[] parts = relativePath.split(DirState.SEPARATOR);
            int i = 0;
            if (parts.length > 1) {
                while (i < parts.length - 1) {
                    dirBuilder = dirBuilder.dirBuilder(parts[i++]);
                }
            }
            dirBuilder.addState(parts[i], FileContentState.builder(parts[i], content));
            return this;
        }

        private DirBuilder dirBuilder(String name) {
            PathState.Builder builder = this.childStates.get(name);
            if (builder != null) {
                return (DirBuilder)builder;
            }
            DirBuilder dirBuilder = DirState.builder(name);
            this.addState(name, dirBuilder);
            return dirBuilder;
        }

        public DirBuilder skip(String relativePath) {
            DirBuilder dirBuilder = this;
            String[] parts = relativePath.split(DirState.SEPARATOR);
            int i = 0;
            if (parts.length > 1) {
                while (i < parts.length - 1) {
                    dirBuilder = dirBuilder.dirBuilder(parts[i++]);
                }
            }
            dirBuilder.addState(parts[i], SkipPathState.builder(parts[i]));
            return this;
        }

        public DirBuilder clear() {
            this.childStates = Collections.emptyMap();
            return this;
        }

        public DirBuilder init(final Path path) throws Exception {
            Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (path != dir) {
                        this.addDir(PathsUtils.toForwardSlashSeparator((String)path.relativize(dir).toString()));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    this.addFile(PathsUtils.toForwardSlashSeparator((String)path.relativize(file).toString()), TestUtils.read(file));
                    return FileVisitResult.CONTINUE;
                }
            });
            return this;
        }

        @Override
        public DirState build() {
            HashMap<String, PathState> states = new HashMap<String, PathState>(this.childStates.size());
            for (Map.Entry<String, PathState.Builder> entry : this.childStates.entrySet()) {
                states.put(entry.getKey(), entry.getValue().build());
            }
            return new DirState(this.name, Collections.unmodifiableMap(states));
        }
    }
}

