/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test.util.fs.state;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.Assert;

public abstract class PathState {
    protected final String name;

    protected PathState(String name) {
        this.name = name;
    }

    protected void assertState(Path parent) {
        if (this.name != null) {
            Path path = parent.resolve(this.name);
            if (!Files.exists(path, new LinkOption[0])) {
                Assert.fail((String)("Path doesn't exist: " + path));
            }
            this.doAssertState(path);
        } else {
            this.doAssertState(parent);
        }
    }

    protected abstract void doAssertState(Path var1);

    public static abstract class Builder {
        protected final String name;

        protected Builder(String name) {
            this.name = name;
        }

        public abstract PathState build();
    }
}

