/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.nio.file.Path;
import java.util.HashSet;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.api.test.FeaturePackRepoTestBase;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.junit.Assert;
import org.junit.Test;

public class ProvisioningTestCase
extends FeaturePackRepoTestBase {
    private static final FeaturePackLocation.FPID FP1_100_GAV = LegacyGalleon1Universe.newFPID((String)"org.jboss.pm.test:fp1", (String)"1", (String)"1.0.0.Final");

    @Override
    protected void doBefore() throws Exception {
        super.doBefore();
        FeaturePackCreator fpCreator = this.initCreator();
        this.createFeaturePacks(fpCreator);
        fpCreator.install();
    }

    @Test
    public void test() throws Exception {
        GalleonBuilder builder = new GalleonBuilder();
        builder.addArtifactResolver(this.repo);
        GalleonFeaturePackConfig fpConfig = ((GalleonFeaturePackConfig.Builder)GalleonFeaturePackConfig.builder((FeaturePackLocation)FP1_100_GAV.getLocation()).includeDefaultConfig("model1", "main")).build();
        GalleonProvisioningConfig config = ((GalleonProvisioningConfig.Builder)((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(fpConfig)).addConfig((GalleonConfigurationWithLayers)((ConfigModel.Builder)((ConfigModel.Builder)ConfigModel.builder().setModel("model1").setName("config1")).addFeature(new FeatureConfig("specA").setParam("name", "13"))).build())).build();
        Assert.assertEquals((Object)config.getFeaturePackDep(FP1_100_GAV.getProducer()).getLocation(), (Object)FP1_100_GAV.getLocation());
        Path prov1 = this.workDir.resolve("prov1.xml");
        try (Provisioning p = builder.newProvisioningBuilder().setInstallationHome(this.installHome).build();){
            p.provision(config);
            Assert.assertEquals((Object)p.getProvisioningConfig(), (Object)config);
            Assert.assertNotNull((Object)p.getProvisioningConfig().getDefinedConfig(new ConfigId("model1", "config1")));
            Assert.assertEquals((Object)p.getProvisioningConfig().getFeaturePackDep(FP1_100_GAV.getProducer()).getLocation(), (Object)FP1_100_GAV.getLocation());
            p.storeProvisioningConfig(config, prov1);
            GalleonProvisioningConfig config2 = p.loadProvisioningConfig(prov1);
            Assert.assertEquals((Object)config, (Object)config2);
            try (Provisioning p2 = builder.newProvisioningBuilder().setInstallationHome(this.installHome).build();){
                Assert.assertEquals((Object)p2.getProvisioningConfig(), (Object)config);
            }
        }
        Assert.assertEquals((Object)APIVersion.getVersion(), (Object)builder.getCoreVersion(prov1));
        try (Provisioning p3 = builder.newProvisioningBuilder(prov1).setInstallationHome(this.installHome).build();){
            Assert.assertEquals((Object)p3.getProvisioningConfig(), (Object)config);
            Assert.assertEquals((long)p3.getProvisioningConfig().getFeaturePackDeps().size(), (long)1L);
            p3.addUniverse("foo", new UniverseSpec("factory"));
            Assert.assertEquals((Object)p3.getProvisioningConfig().getUniverseSpec("foo"), (Object)new UniverseSpec("factory"));
            p3.removeUniverse("foo");
            Assert.assertEquals((long)p3.getProvisioningConfig().getUniverseNamedSpecs().size(), (long)0L);
            Assert.assertNull((Object)p3.getProvisioningConfig().getDefaultUniverse());
            p3.setDefaultUniverse(new UniverseSpec("def"));
            Assert.assertEquals((Object)p3.getProvisioningConfig().getDefaultUniverse(), (Object)new UniverseSpec("def"));
            p3.uninstall(FP1_100_GAV);
            Assert.assertEquals((long)p3.getProvisioningConfig().getFeaturePackDeps().size(), (long)0L);
            p3.install(fpConfig);
            Assert.assertEquals((long)p3.getProvisioningConfig().getFeaturePackDeps().size(), (long)1L);
            p3.uninstall(FP1_100_GAV);
            Assert.assertEquals((long)p3.getProvisioningConfig().getFeaturePackDeps().size(), (long)0L);
            p3.install(fpConfig);
            Assert.assertEquals((long)p3.getProvisioningConfig().getFeaturePackDeps().size(), (long)1L);
        }
        ProvisioningConfig pc = ProvisioningConfig.toConfig((GalleonProvisioningConfig)config);
        GalleonProvisioningConfig pc2 = ProvisioningConfig.toConfig((ProvisioningConfig)pc);
        Assert.assertEquals((Object)config, (Object)pc2);
        GalleonProvisioningConfig configLayers = ((GalleonProvisioningConfig.Builder)((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(fpConfig)).addConfig(GalleonConfigurationWithLayersBuilder.builder().setModel("model1").setName("withlayers").includeLayer("base").build())).build();
        try (Provisioning p4 = builder.newProvisioningBuilder().setInstallationHome(this.installHome).build();){
            p4.provision(configLayers);
            HashSet<String> layers = new HashSet<String>();
            layers.add("base");
            Assert.assertEquals((Object)p4.getProvisioningConfig().getDefinedConfig(new ConfigId("model1", "withlayers")).getIncludedLayers(), layers);
        }
    }

    protected void createFeaturePacks(FeaturePackCreator creator) throws ProvisioningException {
        creator.newFeaturePack(FP1_100_GAV).addFeatureSpec(((FeatureSpec.Builder)FeatureSpec.builder((String)"specA").addParam(FeatureParameterSpec.createId((String)"name")).addParam(FeatureParameterSpec.create((String)"a", (boolean)true)).addPackageDep("specA.pkg")).build()).addFeatureSpec(((FeatureSpec.Builder)FeatureSpec.builder((String)"specB").addParam(FeatureParameterSpec.createId((String)"name")).addParam(FeatureParameterSpec.create((String)"a", (boolean)true)).addFeatureRef(FeatureReferenceSpec.builder((String)"specA").setName("specA").setNillable(false).mapParam("a", "name").build()).addPackageDep("specB.pkg")).build()).addConfigLayer(((ConfigLayerSpec.Builder)((ConfigLayerSpec.Builder)ConfigLayerSpec.builder().setModel("model1").setName("base")).addFeature(new FeatureConfig("specA").setParam("name", "base-prod1").setParam("a", "base"))).build()).addConfig(((ConfigModel.Builder)((ConfigModel.Builder)((ConfigModel.Builder)ConfigModel.builder().setName("main")).setModel("model1").setProperty("prop1", "value1").setProperty("prop2", "value2").addFeature(new FeatureConfig("specB").setParam("name", "b").setParam("a", "a"))).addFeature(new FeatureConfig("specA").setParam("name", "a"))).build(), true).newPackage("p1", true).getFeaturePack().newPackage("specA.pkg").getFeaturePack().newPackage("specB.pkg").addDependency("p2").getFeaturePack().newPackage("p2").getFeaturePack();
    }
}

