/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonFeaturePackDescription;
import org.jboss.galleon.api.GalleonProvisioningLayout;
import org.jboss.galleon.api.GalleonProvisioningRuntime;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilderItf;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.impl.ProvisioningUtil;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;

public interface Provisioning
extends AutoCloseable {
    @Override
    public void close();

    public Path getInstallationHome();

    public boolean isLogTime();

    public boolean isRecordState();

    public static boolean isFeaturePack(Path path) {
        return ProvisioningUtil.isFeaturePack((Path)path);
    }

    public static GalleonFeaturePackDescription getFeaturePackDescription(Path path) throws ProvisioningException {
        return ProvisioningUtil.getFeaturePackDescription((Path)path);
    }

    public void addUniverse(String var1, UniverseSpec var2) throws ProvisioningException;

    public void removeUniverse(String var1) throws ProvisioningException;

    public void setDefaultUniverse(UniverseSpec var1) throws ProvisioningException;

    public GalleonProvisioningConfig getProvisioningConfig() throws ProvisioningException;

    public void setProgressCallback(String var1, ProgressCallback<?> var2);

    public void setProgressTracker(String var1, ProgressTracker<?> var2);

    public List<String> getInstalledPacks(Path var1) throws ProvisioningException;

    default public GalleonProvisioningConfig loadProvisioningConfig(Path file) throws ProvisioningException {
        GalleonProvisioningConfig galleonProvisioningConfig;
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file.toFile());
        try {
            galleonProvisioningConfig = this.loadProvisioningConfig(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new ProvisioningException((Throwable)ex);
            }
        }
        fileInputStream.close();
        return galleonProvisioningConfig;
    }

    public GalleonProvisioningConfig loadProvisioningConfig(InputStream var1) throws ProvisioningException;

    public void storeProvisioningConfig(GalleonProvisioningConfig var1, Path var2) throws ProvisioningException;

    default public void provision(GalleonProvisioningConfig config) throws ProvisioningException {
        this.provision(config, Collections.emptyList(), Collections.emptyMap());
    }

    default public void provision(GalleonProvisioningConfig config, Map<String, String> options) throws ProvisioningException {
        this.provision(config, Collections.emptyList(), options);
    }

    public void provision(GalleonProvisioningConfig var1, List<Path> var2, Map<String, String> var3) throws ProvisioningException;

    default public void provision(Path config) throws ProvisioningException {
        this.provision(config, Collections.emptyMap());
    }

    public void provision(Path var1, Map<String, String> var2) throws ProvisioningException;

    public GalleonProvisioningLayout newProvisioningLayout(GalleonProvisioningConfig var1) throws ProvisioningException;

    public GalleonProvisioningLayout newProvisioningLayout(Path var1, boolean var2) throws ProvisioningException;

    public GalleonProvisioningRuntime getProvisioningRuntime(GalleonProvisioningConfig var1) throws ProvisioningException;

    public UniverseResolver getUniverseResolver();

    public GalleonConfigurationWithLayersBuilderItf buildConfigurationBuilder(GalleonConfigurationWithLayers var1) throws ProvisioningException;

    public boolean hasOrderedFeaturePacksConfig(GalleonProvisioningConfig var1, ConfigId var2) throws ProvisioningException;

    public Set<String> getOrderedFeaturePackPluginLocations(GalleonProvisioningConfig var1) throws ProvisioningException;

    public FsDiff getFsDiff() throws ProvisioningException;

    public void install(FeaturePackLocation var1) throws ProvisioningException;

    public void install(GalleonFeaturePackConfig var1) throws ProvisioningException;

    public void uninstall(FeaturePackLocation.FPID var1) throws ProvisioningException;
}

