/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.api.test.FeaturePackRepoTestBase;
import org.jboss.galleon.api.test.util.fs.state.DirState;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.state.ProvisionedState;
import org.junit.Assert;
import org.junit.Test;

public abstract class PmTestBase
extends FeaturePackRepoTestBase {
    private GalleonProvisioningConfig initialProvisioningConfig;
    private ProvisionedState initialProvisionedState;
    private DirState initialHomeDirState;

    protected abstract void createFeaturePacks(FeaturePackCreator var1) throws ProvisioningException;

    protected GalleonProvisioningConfig initialState() throws ProvisioningException {
        return null;
    }

    protected GalleonProvisioningConfig provisionedConfig() throws ProvisioningException {
        return this.initialProvisioningConfig;
    }

    protected ProvisionedState provisionedState() throws ProvisioningException {
        return this.initialProvisionedState;
    }

    protected DirState provisionedHomeDir() {
        return null;
    }

    protected boolean assertProvisionedHomeDir() {
        return true;
    }

    protected abstract void testPm(Provisioning var1, ProvisioningManager var2) throws ProvisioningException;

    @Override
    protected void doBefore() throws Exception {
        super.doBefore();
        FeaturePackCreator fpCreator = this.initCreator();
        this.createFeaturePacks(fpCreator);
        fpCreator.install();
        this.initialProvisioningConfig = this.initialState();
        if (this.initialProvisioningConfig != null) {
            try (Provisioning pm = this.getPm();){
                pm.provision(this.initialProvisioningConfig);
                try (ProvisioningManager mgr = this.getCorePm();){
                    this.initialProvisionedState = mgr.getProvisionedState();
                }
            }
        }
        this.initialHomeDirState = DirState.rootBuilder().init(this.installHome).build();
    }

    protected DirState.DirBuilder newDirBuilder() {
        DirState.DirBuilder builder = DirState.rootBuilder();
        if (this.isRecordState() || this.initialProvisioningConfig != null) {
            builder.skip(".galleon");
        }
        return builder;
    }

    protected String[] pmErrors() throws ProvisioningException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void main() throws Throwable {
        DirState expectedHomeDir;
        boolean failed;
        block22: {
            String[] errors = this.pmErrors();
            failed = false;
            ProvisioningManager mgr = null;
            try (Provisioning pm = null;){
                mgr = this.getCorePm();
                pm = this.getPm();
                this.testPm(pm, mgr);
                this.pmSuccess();
                if (errors != null) {
                    Assert.fail((String)("Expected failures: " + Arrays.asList(errors)));
                }
                if (this.isRecordState()) {
                    this.assertProvisionedConfig(pm);
                    this.assertProvisionedState(mgr);
                } else if (this.initialProvisioningConfig != null) {
                    pm.close();
                    pm = this.getPm();
                    this.assertProvisionedConfig(pm);
                    this.assertProvisionedState(mgr);
                } else {
                    this.assertNoState();
                }
            }
        }
        if ((expectedHomeDir = this.provisionedHomeDir()) == null) {
            if (!this.assertProvisionedHomeDir()) {
                return;
            }
            expectedHomeDir = failed || this.initialProvisioningConfig != null ? this.initialHomeDirState : this.newDirBuilder().build();
        }
        expectedHomeDir.assertState(this.installHome);
    }

    protected void pmSuccess() {
    }

    protected void pmFailure(Throwable t) throws Throwable {
        throw t;
    }

    protected void assertProvisionedState(ProvisioningManager pm) throws ProvisioningException {
        this.assertProvisionedState(pm, this.provisionedState());
    }

    protected void assertProvisionedConfig(Provisioning pm) throws ProvisioningException {
        PmTestBase.assertProvisioningConfig(pm, this.provisionedConfig());
    }

    protected void assertNoState() throws ProvisioningException {
        if (Files.exists(this.installHome.resolve(".galleon"), new LinkOption[0])) {
            Assert.fail((String)("Unexpected provisioning state " + this.installHome.resolve(".galleon")));
        }
    }

    protected void assertErrors(Throwable t, String ... msgs) {
        int i = 0;
        if (msgs != null) {
            while (t != null && i < msgs.length) {
                Assert.assertEquals((Object)msgs[i++], (Object)t.getLocalizedMessage());
                t = t.getCause();
            }
        }
        if (t != null) {
            Assert.fail((String)("Unexpected error: " + t.getLocalizedMessage()));
        }
        if (i < msgs.length - 1) {
            Assert.fail((String)("Not reported error: " + msgs[i]));
        }
    }
}

