/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aesh.command.completer.OptionCompleter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GalleonCommandExecutionContext;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.cmd.FPLocationParser;
import org.jboss.galleon.cli.cmd.FPLocationParserException;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.PathsUtils;

public class FPLocationCompleter
implements OptionCompleter<PmCompleterInvocation> {
    private Path installation;

    public void complete(PmCompleterInvocation completerInvocation) {
        try {
            this.doComplete(completerInvocation);
        }
        catch (ProvisioningException | CommandExecutionException ex) {
            CliLogging.completionException(ex);
        }
    }

    private void doComplete(PmCompleterInvocation completerInvocation) throws ProvisioningException, CommandExecutionException {
        Path p;
        final PmSession pmSession = completerInvocation.getPmSession();
        final UniverseManager resolver = pmSession.getUniverse();
        this.installation = completerInvocation.getCommand() instanceof CommandWithInstallationDirectory ? ((CommandWithInstallationDirectory)completerInvocation.getCommand()).getInstallationDirectory(completerInvocation.getAeshContext()) : null;
        String coreVersion = APIVersion.getVersion();
        if (this.installation != null && Files.exists(p = PathsUtils.getProvisioningXml((Path)this.installation), new LinkOption[0])) {
            coreVersion = completerInvocation.getPmSession().getGalleonBuilder().getCoreVersion(p);
        }
        final GalleonCommandExecutionContext bridge = completerInvocation.getPmSession().getGalleonContext(coreVersion);
        final UniverseSpec defaultUniverse = bridge.getDefaultUniverseSpec(this.installation);
        final Set<String> aliases = bridge.getUniverseNames(this.installation);
        String buffer = completerInvocation.getGivenCompleteValue();
        final ArrayList<String> candidates = new ArrayList<String>();
        FPLocationParser.ParsedFPLocation loc = null;
        try {
            if (buffer.isEmpty()) {
                if (defaultUniverse != null) {
                    this.getAllProducers(null, defaultUniverse, resolver.getUniverse(defaultUniverse), candidates);
                }
                for (String name : aliases) {
                    UniverseSpec u = bridge.getUniverseSpec(this.installation, name);
                    if (u.equals((Object)defaultUniverse)) continue;
                    this.getAllProducers(u.toString(), u, resolver.getUniverse(u), candidates);
                }
            } else {
                loc = FPLocationParser.parse(buffer, new FPLocationParser.FPLocationCompletionConsumer(){

                    @Override
                    public void completeProducer(String producer) throws FPLocationParserException, ProvisioningException {
                        if (defaultUniverse != null) {
                            FPLocationCompleter.this.getProducers(producer, null, resolver.getUniverse(defaultUniverse), candidates);
                        }
                        for (String name : aliases) {
                            UniverseSpec u = bridge.getUniverseSpec(FPLocationCompleter.this.installation, name);
                            if (u.equals((Object)defaultUniverse)) continue;
                            FPLocationCompleter.this.getProducers(producer, name, resolver.getUniverse(u), candidates);
                        }
                    }

                    @Override
                    public void completeUniverse(FPLocationParser.ParsedFPLocation parsedLocation, String universe) throws FPLocationParserException, ProvisioningException {
                        for (String name : aliases) {
                            UniverseSpec spec = bridge.getUniverseSpec(FPLocationCompleter.this.installation, name);
                            if (spec == null || !resolver.getUniverse(spec).hasProducer(parsedLocation.getProducer())) continue;
                            if (name.equals(universe)) {
                                candidates.add(name + ":");
                                continue;
                            }
                            if (!name.startsWith(universe)) continue;
                            candidates.add(name);
                        }
                    }

                    @Override
                    public void completeUniverseLocation(FPLocationParser.ParsedFPLocation parsedLocation, String universeLocation) throws FPLocationParserException, ProvisioningException {
                        for (String name : aliases) {
                            UniverseSpec spec = bridge.getUniverseSpec(FPLocationCompleter.this.installation, name);
                            if (spec == null || candidates.contains(spec.getLocation()) || !spec.getFactory().equals(parsedLocation.getUniverseFactory()) || !resolver.getUniverse(spec).hasProducer(parsedLocation.getProducer())) continue;
                            if (spec.getLocation().equals(universeLocation)) {
                                candidates.add(spec.getLocation() + ")");
                                break;
                            }
                            if (!spec.getLocation().startsWith(universeLocation)) break;
                            candidates.add(spec.getLocation());
                            break;
                        }
                    }

                    @Override
                    public void completeChannel(FPLocationParser.ParsedFPLocation parsedLocation, String channel) throws FPLocationParserException, ProvisioningException {
                        Producer<?> p = FPLocationCompleter.this.getProducer(parsedLocation, pmSession, bridge);
                        if (p == null) {
                            return;
                        }
                        for (Channel c : p.getChannels()) {
                            if (c.getName().equals(channel)) {
                                candidates.add(channel);
                                continue;
                            }
                            if (!c.getName().startsWith(channel)) continue;
                            candidates.add(c.getName());
                        }
                    }

                    @Override
                    public void completeFrequency(FPLocationParser.ParsedFPLocation parsedLocation, String frequency) throws FPLocationParserException, ProvisioningException {
                        Producer<?> p = FPLocationCompleter.this.getProducer(parsedLocation, pmSession, bridge);
                        if (p == null) {
                            return;
                        }
                        for (String freq : p.getFrequencies()) {
                            if (freq.equals(frequency)) {
                                candidates.add(freq);
                                continue;
                            }
                            if (!freq.startsWith(frequency)) continue;
                            candidates.add(freq);
                        }
                    }

                    @Override
                    public void completeChannelSeparator(FPLocationParser.ParsedFPLocation parsedLocation) throws FPLocationParserException, ProvisioningException {
                        candidates.add(":");
                    }

                    @Override
                    public void completeBuild(FPLocationParser.ParsedFPLocation parsedLocation, String build) throws FPLocationParserException, ProvisioningException {
                        UniverseSpec spec = null;
                        spec = parsedLocation.getUniverseName() != null ? bridge.getUniverseSpec(FPLocationCompleter.this.installation, parsedLocation.getUniverseName()) : (parsedLocation.getUniverseFactory() == null ? bridge.getDefaultUniverseSpec(FPLocationCompleter.this.installation) : new UniverseSpec(parsedLocation.getUniverseFactory(), parsedLocation.getUniverseLocation()));
                        if (spec != null) {
                            String latestBuild = null;
                            if (parsedLocation.getFrequency() == null) {
                                FeaturePackLocation.FPID id = new FeaturePackLocation(spec, parsedLocation.getProducer(), parsedLocation.getChannel(), null, null).getFPID();
                                latestBuild = pmSession.getUniverse().getUniverse(spec).getProducer(parsedLocation.getProducer()).getChannel(parsedLocation.getChannel()).getLatestBuild(id);
                            } else {
                                FeaturePackLocation loc = new FeaturePackLocation(spec, parsedLocation.getProducer(), parsedLocation.getChannel(), parsedLocation.getFrequency(), null);
                                latestBuild = pmSession.getUniverse().getUniverse(spec).getProducer(parsedLocation.getProducer()).getChannel(parsedLocation.getChannel()).getLatestBuild(loc);
                            }
                            if (latestBuild != null && latestBuild.startsWith(build)) {
                                candidates.add(latestBuild);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            CliLogging.completionException(ex);
            return;
        }
        completerInvocation.addAllCompleterValues(candidates);
        if (candidates.size() == 1) {
            if (completerInvocation.getGivenCompleteValue().endsWith((String)candidates.get(0))) {
                completerInvocation.setAppendSpace(true);
            } else {
                completerInvocation.setAppendSpace(false);
            }
            completerInvocation.setOffset(completerInvocation.getGivenCompleteValue().length() - (loc == null ? 0 : loc.getMarker() + 1));
        }
    }

    private Producer<?> getProducer(FPLocationParser.ParsedFPLocation parsedLocation, PmSession pmSession, GalleonCommandExecutionContext bridge) {
        try {
            UniverseSpec spec = null;
            spec = parsedLocation.getUniverseName() != null ? bridge.getUniverseSpec(this.installation, parsedLocation.getUniverseName()) : (parsedLocation.getUniverseFactory() == null ? bridge.getDefaultUniverseSpec(this.installation) : new UniverseSpec(parsedLocation.getUniverseFactory(), parsedLocation.getUniverseLocation()));
            if (spec == null) {
                return null;
            }
            Universe<?> universe = pmSession.getUniverse().getUniverse(spec);
            if (universe == null) {
                return null;
            }
            for (Producer p : universe.getProducers()) {
                if (!p.getName().equals(parsedLocation.getProducer())) continue;
                return p;
            }
        }
        catch (ProvisioningException ex) {
            CliLogging.completionException(ex);
        }
        return null;
    }

    private void getAllProducers(String name, UniverseSpec spec, Universe<?> universe, List<String> candidates) throws ProvisioningException {
        for (Producer p : universe.getProducers()) {
            for (Channel c : p.getChannels()) {
                if (candidates.contains(p.getName())) continue;
                candidates.add(p.getName() + ":" + c.getName());
            }
        }
    }

    private void getProducers(String producerName, String universeName, Universe<?> universe, List<String> candidates) throws ProvisioningException {
        for (Producer p : universe.getProducers()) {
            if (candidates.contains(p.getName()) || !p.getName().startsWith(producerName)) continue;
            if (universeName == null) {
                for (Channel c : p.getChannels()) {
                    candidates.add(p.getName() + ":" + c.getName());
                }
                continue;
            }
            for (Channel c : p.getChannels()) {
                candidates.add(p.getName() + "@" + universeName + ":" + c.getName());
            }
        }
    }
}

