/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.utils.Config;
import org.jboss.galleon.cli.CliMain;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.ToolModes;
import org.jboss.galleon.cli.cmd.CommandDomain;

public class HelpSupport {
    private static final String TAB = "    ";

    public static String getToolHelp(PmSession session, CommandRegistry<? extends CommandInvocation> registry) throws CommandNotFoundException {
        StringBuilder sb = new StringBuilder();
        sb.append("== DEFAULT MODE ==").append(Config.getLineSeparator());
        session.getToolModes().setMode(ToolModes.Mode.NOMINAL);
        sb.append(HelpSupport.buildHelp(registry, registry.getAllCommandNames(), false));
        sb.append(Config.getLineSeparator()).append("== EDIT MODE ==").append(Config.getLineSeparator());
        session.getToolModes().setMode(ToolModes.Mode.EDIT);
        sb.append(HelpSupport.buildHelp(registry, registry.getAllCommandNames(), true));
        return sb.toString();
    }

    public static List<String> getAvailableCommands(CommandRegistry<? extends CommandInvocation> registry, boolean includeChilds, boolean onlyEnabled) {
        ArrayList<String> lst = new ArrayList<String>();
        for (String c : registry.getAllCommandNames()) {
            CommandLineParser cmdParser;
            try {
                cmdParser = registry.getCommand(c, null).getParser();
            }
            catch (CommandNotFoundException ex) {
                continue;
            }
            CommandActivator activator = cmdParser.getProcessedCommand().getActivator();
            if (activator != null && !activator.isActivated(new ParsedCommand(cmdParser.getProcessedCommand()))) continue;
            if (cmdParser.isGroupCommand() && includeChilds) {
                for (CommandLineParser child : cmdParser.getAllChildParsers()) {
                    CommandActivator childActivator = child.getProcessedCommand().getActivator();
                    if (onlyEnabled && childActivator != null && !childActivator.isActivated(new ParsedCommand(child.getProcessedCommand()))) continue;
                    lst.add(c + " " + child.getProcessedCommand().name());
                }
                continue;
            }
            lst.add(c);
        }
        return lst;
    }

    public static String buildHelp(CommandRegistry<? extends CommandInvocation> registry, Set<String> commands) throws CommandNotFoundException {
        return HelpSupport.buildHelp(registry, commands, true);
    }

    private static String buildHelp(CommandRegistry<? extends CommandInvocation> registry, Set<String> commands, boolean footer) throws CommandNotFoundException {
        TreeMap<CommandDomain, TreeSet<String>> groupedCommands = new TreeMap<CommandDomain, TreeSet<String>>();
        for (String command : commands) {
            TreeSet<String> currentDescriptions;
            CommandDomain group = CommandDomain.getDomain(registry.getCommand(command, null).getParser().getCommand());
            String commandTree = HelpSupport.getCommandTree(registry, command);
            if (group == null) {
                group = CommandDomain.OTHERS;
            }
            if ((currentDescriptions = (TreeSet<String>)groupedCommands.get(group)) == null) {
                currentDescriptions = new TreeSet<String>();
                groupedCommands.put(group, currentDescriptions);
            }
            currentDescriptions.add(commandTree);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry groupedCommand : groupedCommands.entrySet()) {
            sb.append(Config.getLineSeparator());
            sb.append("== ").append(((CommandDomain)groupedCommand.getKey()).getDescription()).append(" ==");
            sb.append(Config.getLineSeparator());
            for (String description : (Set)groupedCommand.getValue()) {
                sb.append(description);
                sb.append(Config.getLineSeparator());
            }
        }
        if (footer) {
            sb.append(HelpSupport.getHelpFooter());
        }
        return sb.toString();
    }

    private static String getCommandTree(CommandRegistry<? extends CommandInvocation> registry, String command) throws CommandNotFoundException {
        CommandLineParser cmdParser = registry.getCommand(command, null).getParser();
        StringBuilder sb = new StringBuilder();
        ProcessedCommand processedCommand = cmdParser.getProcessedCommand();
        sb.append(processedCommand.name());
        if (processedCommand.hasArguments() || processedCommand.hasArgument()) {
            sb.append(" <arg>");
        }
        sb.append(" ").append(HelpSupport.trimDescription(processedCommand.description()));
        sb.append(HelpSupport.getCommandOptions((ProcessedCommand<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation>)processedCommand, 0));
        if (!cmdParser.getAllChildParsers().isEmpty()) {
            List allChildParsers = cmdParser.getAllChildParsers();
            allChildParsers.sort((o1, o2) -> {
                ProcessedCommand pc1 = o1.getProcessedCommand();
                ProcessedCommand pc2 = o2.getProcessedCommand();
                return pc1.name().compareTo(pc2.name());
            });
            for (CommandLineParser childParser : allChildParsers) {
                ProcessedCommand childProcessedCommand = childParser.getProcessedCommand();
                sb.append(Config.getLineSeparator()).append(TAB);
                sb.append(childProcessedCommand.name());
                if (childProcessedCommand.hasArguments() || childProcessedCommand.hasArgument()) {
                    sb.append(" <arg>");
                }
                sb.append(" ").append(HelpSupport.trimDescription(childProcessedCommand.description()));
                sb.append(HelpSupport.getCommandOptions((ProcessedCommand<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation>)childProcessedCommand, 4));
            }
        }
        return sb.toString();
    }

    private static String getHelpFooter() {
        try {
            return HelpSupport.getHelp(HelpSupport.getHelpPath("help-command.txt"));
        }
        catch (IOException e) {
            return "Failed to read help-command.txt. " + e.getLocalizedMessage();
        }
    }

    private static String getCommandOptions(ProcessedCommand<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> command, int offset) {
        StringBuilder sb = new StringBuilder();
        if (command.hasOptions()) {
            TreeMap<String, String> orderedOptions = new TreeMap<String, String>();
            sb.append(Config.getLineSeparator());
            if (command.hasArgument() || command.hasArguments()) {
                HelpSupport.processArguments(command, offset, sb);
                if (sb.lastIndexOf(Config.getLineSeparator()) != sb.length() - 1) {
                    sb.append(Config.getLineSeparator());
                }
            }
            List options = command.getOptions();
            for (ProcessedOption processedOption : options) {
                orderedOptions.put(processedOption.name(), HelpSupport.trimDescription(processedOption.getFormattedOption(offset + TAB.length(), 0, 80)));
            }
            for (Map.Entry entry : orderedOptions.entrySet()) {
                sb.append((String)entry.getValue());
                if (entry.equals(orderedOptions.lastEntry())) continue;
                sb.append(Config.getLineSeparator());
            }
        } else if (command.hasArguments() || command.hasArgument()) {
            sb.append(Config.getLineSeparator());
            HelpSupport.processArguments(command, offset, sb);
        }
        return sb.toString();
    }

    private static void processArguments(ProcessedCommand<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation> command, int offset, StringBuilder sb) {
        if (command.hasArgument()) {
            if (command.getArgument().description() != null && !"".equals(command.getArgument().description())) {
                HelpSupport.handleOffset(offset, sb);
                sb.append(TAB).append("<arg> ").append(HelpSupport.trimDescription(command.getArgument().description()));
            }
        } else if (command.hasArguments() && command.getArguments().description() != null && !"".equals(command.getArguments().description())) {
            HelpSupport.handleOffset(offset, sb);
            sb.append(TAB).append("<arg> ").append(HelpSupport.trimDescription(command.getArguments().description()));
        }
    }

    private static String trimDescription(String description) {
        if (description.contains(".")) {
            description = description.substring(0, description.indexOf("."));
        }
        return description;
    }

    private static void handleOffset(int offset, StringBuilder sb) {
        if (offset > 0) {
            if (offset % TAB.length() == 0) {
                sb.append(TAB);
            } else {
                for (int i = 0; i < offset; ++i) {
                    sb.append(" ");
                }
            }
        }
    }

    private static String getHelp(String path) throws IOException {
        InputStream helpInput = CliMain.class.getResourceAsStream(path);
        if (helpInput != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput, StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                String helpLine = reader.readLine();
                while (helpLine != null) {
                    builder.append(helpLine).append(Config.getLineSeparator());
                    helpLine = reader.readLine();
                }
                String string = builder.toString();
                return string;
            }
        }
        return "Failed to locate help description " + path;
    }

    private static String getHelpPath(String file) {
        return "/help/" + file;
    }
}

