/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.AbstractStateCommand;
import org.jboss.galleon.cli.cmd.state.pkg.AbstractPackageCommand;

@CommandDefinition(name="search", description="Search the provisioning state for content")
public class StateSearchCommand
extends AbstractStateCommand {
    @Option(required=false, activator=QueryActivator.class, description="Text to search for")
    private String query;
    @Option(required=false, name="package", completer=AbstractPackageCommand.PackageCompleter.class, activator=PackageActivator.class, description="Path to a package")
    private String pkg;
    @Option(required=false, name="include-dependencies", hasValue=false, description="Include dependencies in the search")
    private Boolean inDependencies;

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.state.core.CoreStateSearchCommand";
    }

    public String getQuery() {
        return this.query;
    }

    public String getPkg() {
        return this.pkg;
    }

    public Boolean getInDependencies() {
        return this.inDependencies;
    }

    public static class PackageActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("query");
            return opt == null || opt.value() == null;
        }
    }

    public static class QueryActivator
    implements OptionActivator {
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("package");
            return opt == null || opt.value() == null;
        }
    }
}

