/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.io.IOException;
import java.nio.file.Paths;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class MavenConfigXml {
    public static final String REPOSITORIES = "repositories";
    public static final String LOCAL_REPOSITORY = "local-repository";
    public static final String SETTINGS = "settings";
    public static final String NAME = "name";
    public static final String SNAPSHOT_UPDATE_POLICY = "snapshotUpdatePolicy";
    public static final String RELEASE_UPDATE_POLICY = "releaseUpdatePolicy";
    public static final String ENABLE_SNAPSHOT = "enableSnapshot";
    public static final String ENABLE_RELEASE = "enableRelease";
    public static final String TYPE = "type";
    public static final String REPOSITORY = "repository";
    public static final String MAVEN = "maven";
    public static final String OFFLINE = "offline";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(XMLExtendedStreamReader reader, MavenConfig config) throws ProvisioningException, XMLStreamException, IOException {
        config.disableAdvertise();
        try {
            block28: while (reader.hasNext()) {
                switch (reader.nextTag()) {
                    case 2: {
                        return;
                    }
                    case 1: {
                        switch (reader.getLocalName()) {
                            case "repositories": {
                                MavenConfigXml.readRepositories(reader, config);
                                continue block28;
                            }
                            case "local-repository": {
                                config.setLocalRepository(Paths.get(reader.getElementText(), new String[0]));
                                continue block28;
                            }
                            case "settings": {
                                config.setSettings(Paths.get(reader.getElementText(), new String[0]));
                                continue block28;
                            }
                            case "snapshotUpdatePolicy": {
                                config.setDefaultSnapshotPolicy(reader.getElementText());
                                continue block28;
                            }
                            case "releaseUpdatePolicy": {
                                config.setDefaultReleasePolicy(reader.getElementText());
                                continue block28;
                            }
                            case "enableSnapshot": {
                                config.enableSnapshot(Boolean.parseBoolean(reader.getElementText()));
                                continue block28;
                            }
                            case "enableRelease": {
                                config.enableRelease(Boolean.parseBoolean(reader.getElementText()));
                                continue block28;
                            }
                            case "offline": {
                                config.enableOffline(Boolean.parseBoolean(reader.getElementText()));
                                continue block28;
                            }
                        }
                        throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                    }
                }
                throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
            }
        }
        finally {
            config.enableAdvertise();
        }
    }

    private static void readRepositories(XMLExtendedStreamReader reader, MavenConfig config) throws ProvisioningException, XMLStreamException, IOException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!reader.getLocalName().equals(REPOSITORIES)) continue block10;
                    return;
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "repository": {
                            String snapshot = reader.getAttributeValue(null, ENABLE_SNAPSHOT);
                            String release = reader.getAttributeValue(null, ENABLE_RELEASE);
                            MavenRemoteRepository repo = new MavenRemoteRepository(reader.getAttributeValue(null, NAME), reader.getAttributeValue(null, TYPE), reader.getAttributeValue(null, RELEASE_UPDATE_POLICY), reader.getAttributeValue(null, SNAPSHOT_UPDATE_POLICY), release == null ? null : Boolean.valueOf(Boolean.parseBoolean(release)), snapshot == null ? null : Boolean.valueOf(Boolean.parseBoolean(snapshot)), reader.getElementText());
                            config.addRemoteRepository(repo);
                            continue block10;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
    }
}

