/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.terminal.Connection;
import org.aesh.utils.Config;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.cli.CliMavenArtifactRepositoryManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GalleonCommandExecutionContext;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.ToolModes;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public class PmSession
implements CompleterInvocationProvider<PmCompleterInvocation>,
CommandActivatorProvider,
OptionActivatorProvider<OptionActivator> {
    private static final String EDIT_MODE_PROMPT = "!edit!";
    private PrintStream out;
    private PrintStream err;
    private final Configuration config;
    private final CliMavenArtifactRepositoryManager maven;
    private final MavenListener mavenListener;
    private final UniverseManager universe;
    private AeshContext ctx;
    private boolean rethrow = false;
    private final boolean interactive;
    private ToolModes toolModes;
    private String promptRoot;
    private Path previousDir;
    private Connection connection;
    private GalleonBuilder galleonBuilder;
    private GalleonCommandExecutionContext state;
    private final UniverseResolver universeResolver;
    private static final Map<String, GalleonCommandExecutionContext> contexts = new HashMap<String, GalleonCommandExecutionContext>();

    public PmSession(Configuration config) throws Exception {
        this(config, true);
    }

    public PmSession(Configuration config, UniverseSpec builtin) throws Exception {
        this(config, true, builtin);
    }

    public PmSession(Configuration config, boolean interactive) throws Exception {
        this(config, interactive, null);
    }

    public PmSession(Configuration config, boolean interactive, UniverseSpec builtin) throws Exception {
        this.config = config;
        this.mavenListener = new MavenListener();
        this.maven = new CliMavenArtifactRepositoryManager(config.getMavenConfig(), this.mavenListener);
        this.universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver((RepositoryArtifactResolver)this.maven)).build();
        this.universe = new UniverseManager(this, config, this.maven, this.universeResolver, builtin);
        this.interactive = interactive;
        this.galleonBuilder = new GalleonBuilder().setUniverseResolver(this.universeResolver);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    public GalleonCommandExecutionContext getState() {
        return this.state;
    }

    public void setState(GalleonCommandExecutionContext state) {
        this.state = state;
    }

    public GalleonBuilder getGalleonBuilder() {
        return this.galleonBuilder;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public UniverseResolver getUniverseResolver() {
        return this.universeResolver;
    }

    private static synchronized GalleonCommandExecutionContext getCoreContext(String version, PmSession session, GalleonBuilder galleonBuilder) throws Exception {
        GalleonCommandExecutionContext ctx = contexts.get(version);
        if (ctx == null) {
            URLClassLoader coreLoader = galleonBuilder.getCoreClassLoader(version);
            URLClassLoader loader = PmSession.getCliAdapterClassLoader(coreLoader);
            Class<?> clazz = Class.forName("org.jboss.galleon.cli.core.ProvisioningSession", true, loader);
            ctx = (GalleonCommandExecutionContext)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            ctx.init(session, loader);
            contexts.put(version, ctx);
        }
        return ctx;
    }

    static synchronized void removeCoreContext(String version) {
        contexts.remove(version);
    }

    private static synchronized URLClassLoader getCliAdapterClassLoader(URLClassLoader coreLoader) throws ProvisioningException {
        String apiVersion = APIVersion.getVersion();
        try {
            Path corePath = Files.createTempDirectory("galleon-core-cli-base-dir", new FileAttribute[0]);
            corePath.toFile().deleteOnExit();
            File defaultCore = corePath.resolve("galleon-cli-core-adapter.jar").toFile();
            try (InputStream input = PmSession.class.getClassLoader().getResourceAsStream("galleon-cli-core-adapter-" + apiVersion + ".jar");
                 FileOutputStream output = new FileOutputStream(defaultCore, false);){
                input.transferTo(output);
            }
            defaultCore.deleteOnExit();
            URL[] cp = new URL[1];
            try {
                cp[0] = defaultCore.toURI().toURL();
                return new URLClassLoader(cp, (ClassLoader)coreLoader);
            }
            catch (Exception ex) {
                throw new ProvisioningException((Throwable)ex);
            }
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    public GalleonCommandExecutionContext getGalleonContext(String coreVersion) throws ProvisioningException, CommandExecutionException {
        try {
            if (coreVersion == null) {
                coreVersion = APIVersion.getVersion();
            }
            return PmSession.getCoreContext(coreVersion, this, this.galleonBuilder);
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex.getLocalizedMessage());
        }
    }

    void setModes(ToolModes toolModes) {
        this.toolModes = toolModes;
    }

    ToolModes getToolModes() {
        return this.toolModes;
    }

    public void clearLayoutCache() throws IOException {
        this.config.clearLayoutCache();
    }

    public void throwException() {
        this.rethrow = true;
    }

    public boolean isExceptionRethrown() {
        return this.rethrow;
    }

    public void close() {
        this.universe.close();
    }

    MavenRepoManager getMavenRepoManager() {
        return this.maven;
    }

    void setAeshContext(AeshContext ctx) {
        this.ctx = ctx;
    }

    public AeshContext getAeshContext() {
        return this.ctx;
    }

    public MessageWriter getMessageWriter(boolean verbose) {
        return new DefaultMessageWriter(this.out, this.err, verbose);
    }

    public UniverseManager getUniverse() {
        return this.universe;
    }

    public void commandStart(PmCommandInvocation session) {
        this.maven.commandStart();
    }

    public void commandEnd(PmCommandInvocation session) {
        this.maven.commandEnd();
    }

    public void setToolMode(ToolModes.Mode mode, String name) {
        if (ToolModes.Mode.NOMINAL.equals((Object)mode)) {
            this.toolModes.setMode(ToolModes.Mode.NOMINAL);
            this.promptRoot = null;
        } else {
            this.toolModes.setMode(ToolModes.Mode.EDIT);
            this.promptRoot = EDIT_MODE_PROMPT + (String)(name == null ? "" : name + "!");
        }
    }

    public Path getPreviousDirectory() {
        return this.previousDir;
    }

    public void setCurrentDirectory(Path path) throws IOException {
        FileResource res = new FileResource(path);
        List files = res.resolve(this.ctx.getCurrentWorkingDirectory());
        if (!((Resource)files.get(0)).isDirectory()) {
            throw new IOException(CliErrors.unknownDirectory(path.getFileName().toString()));
        }
        this.previousDir = Paths.get(this.ctx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
        this.ctx.setCurrentWorkingDirectory((Resource)files.get(0));
    }

    public void println(String txt) {
        this.out.print(txt + Config.getLineSeparator());
    }

    public void print(String txt) {
        this.out.print(txt);
    }

    public Configuration getPmConfiguration() {
        return this.config;
    }

    public Prompt buildPrompt() {
        ToolModes.Mode mode = this.toolModes.getActiveMode();
        Prompt prompt = null;
        switch (mode) {
            case NOMINAL: {
                prompt = this.buildPrompt(this.ctx.getCurrentWorkingDirectory().getName());
                break;
            }
            case EDIT: {
                prompt = this.buildPrompt("");
            }
        }
        return prompt;
    }

    public Prompt buildPrompt(String name) {
        return new Prompt('[' + (this.promptRoot == null ? "" : this.promptRoot) + name + "]$ ");
    }

    public static Path getWorkDir(AeshContext aeshCtx) {
        return Paths.get(aeshCtx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    void setErr(PrintStream err) {
        this.err = err;
    }

    PrintStream getErr() {
        return this.err;
    }

    public PmCompleterInvocation enhanceCompleterInvocation(CompleterInvocation completerInvocation) {
        return new PmCompleterInvocation(completerInvocation, this);
    }

    public CommandActivator enhanceCommandActivator(CommandActivator ca) {
        if (ca instanceof PmCommandActivator) {
            ((PmCommandActivator)ca).setPmSession(this);
        }
        return ca;
    }

    public OptionActivator enhanceOptionActivator(OptionActivator oa) {
        if (oa instanceof PmOptionActivator) {
            ((PmOptionActivator)oa).setPmSession(this);
        }
        return oa;
    }

    public void enableMavenTrace(boolean b) {
        this.mavenListener.setActive(b);
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isAnsiSupported() {
        return this.connection != null && this.connection.supportsAnsi();
    }

    private class MavenListener
    implements RepositoryListener {
        private static final String MAVEN = "[MAVEN] ";
        private boolean active;

        private MavenListener() {
        }

        void setActive(boolean active) {
            this.active = active;
        }

        public void artifactDownloaded(RepositoryEvent re) {
            if (this.active && re != null) {
                String artifact = re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension();
                if (re.getException() == null) {
                    PmSession.this.println("[MAVEN] downloaded " + artifact + " from " + re.getRepository().getId());
                } else if (re.getException() instanceof ArtifactNotFoundException) {
                    PmSession.this.println("[MAVEN] artifact " + artifact + " not found in " + re.getRepository().getId());
                } else {
                    PmSession.this.println(MAVEN + re.getException().getLocalizedMessage() + " while downloading artifact " + artifact);
                }
            }
        }

        public void artifactDownloading(RepositoryEvent re) {
            if (this.active && re != null) {
                PmSession.this.println("[MAVEN] attempting to download " + re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension() + (String)(re.getRepository() != null ? " from " + re.getRepository().getId() : ""));
            }
        }

        public void artifactDescriptorInvalid(RepositoryEvent re) {
        }

        public void artifactDescriptorMissing(RepositoryEvent re) {
        }

        public void metadataInvalid(RepositoryEvent re) {
        }

        public void artifactResolving(RepositoryEvent re) {
        }

        public void artifactResolved(RepositoryEvent re) {
        }

        public void metadataResolving(RepositoryEvent re) {
        }

        public void metadataResolved(RepositoryEvent re) {
        }

        public void metadataDownloading(RepositoryEvent re) {
        }

        public void metadataDownloaded(RepositoryEvent re) {
        }

        public void artifactInstalling(RepositoryEvent re) {
        }

        public void artifactInstalled(RepositoryEvent re) {
        }

        public void metadataInstalling(RepositoryEvent re) {
        }

        public void metadataInstalled(RepositoryEvent re) {
        }

        public void artifactDeploying(RepositoryEvent re) {
        }

        public void artifactDeployed(RepositoryEvent re) {
        }

        public void metadataDeploying(RepositoryEvent re) {
        }

        public void metadataDeployed(RepositoryEvent re) {
        }
    }
}

